/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.admin.handler;

import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.admin.AbstractAdminCommandHandler;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.switcher.Switcher;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SwitcherHandler
extends AbstractAdminCommandHandler {
    private static final String[] commands = new String[]{"/switcher/set", "/switcher/get", "/switcher/getAll"};

    @Override
    protected void process(String command, Map<String, String> params, Map<String, String> attachments, JSONObject result) {
        if (commands[0].equals(command)) {
            String name = params.get("name");
            String value = params.get("value");
            if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)value)) {
                throw new MotanServiceException("switcher name or value is empty");
            }
            name = name.trim();
            boolean bValue = Boolean.parseBoolean(value.trim());
            try {
                MotanSwitcherUtil.setSwitcherValue(name, bValue);
            }
            catch (Exception ignore) {
                Switcher switcher = MotanSwitcherUtil.getOrInitSwitcher(name, bValue);
                switcher.setValue(bValue);
            }
            result.put(name, (Object)MotanSwitcherUtil.isOpen(name));
        } else if (commands[1].equals(command)) {
            String name = params.get("name");
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new MotanServiceException("switcher name is empty");
            }
            name = name.trim();
            result.put(name, (Object)MotanSwitcherUtil.isOpen(name));
        } else if (commands[2].equals(command)) {
            JSONObject jsonObject = new JSONObject();
            List<Switcher> switchers = MotanSwitcherUtil.getSwitcherService().getAllSwitchers();
            if (switchers != null && !switchers.isEmpty()) {
                for (Switcher switcher : switchers) {
                    jsonObject.put(switcher.getName(), (Object)switcher.isOn());
                }
            }
            result.put("switchers", (Object)jsonObject);
        }
    }

    @Override
    public String[] getCommandName() {
        return commands;
    }
}

