/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.admin.handler;

import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.admin.AbstractAdminCommandHandler;
import com.weibo.api.motan.runtime.GlobalRuntime;
import com.weibo.api.motan.runtime.RuntimeInfo;
import com.weibo.api.motan.util.MotanGlobalConfigUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class RuntimeInfoHandler
extends AbstractAdminCommandHandler {
    private static final Map<String, Supplier<Map<String, ? extends RuntimeInfo>>> RUNTIME_INFO_FUNCTIONS = new HashMap<String, Supplier<Map<String, ? extends RuntimeInfo>>>();
    private static final Set<String> DEFAULT_KEYS = new HashSet<String>();

    @Override
    protected void process(String command, Map<String, String> params, Map<String, String> attachments, JSONObject result) {
        String keyString;
        result.put("instanceType", (Object)"motan-java");
        result.put("globalConfigs", MotanGlobalConfigUtil.getConfigs());
        Set<String> keys = DEFAULT_KEYS;
        if (params.containsKey("keys") && StringUtils.isNotBlank((CharSequence)(keyString = params.get("keys")))) {
            keys = Arrays.stream(keyString.split(",")).map(String::trim).collect(Collectors.toSet());
        }
        for (String key : keys) {
            Supplier<Map<String, ? extends RuntimeInfo>> supplier = RUNTIME_INFO_FUNCTIONS.get(key);
            if (supplier == null) continue;
            this.addInfos(supplier.get(), key, result);
        }
    }

    private void addInfos(Map<String, ? extends RuntimeInfo> infos, String key, JSONObject result) {
        if (!infos.isEmpty()) {
            JSONObject infoObject = new JSONObject();
            infos.forEach((k, v) -> infoObject.put(k, v.getRuntimeInfo()));
            result.put(key, (Object)infoObject);
        }
    }

    @Override
    public String[] getCommandName() {
        return new String[]{"/runtime/info"};
    }

    static {
        RUNTIME_INFO_FUNCTIONS.put("registries", GlobalRuntime::getRuntimeRegistries);
        RUNTIME_INFO_FUNCTIONS.put("clusters", GlobalRuntime::getRuntimeClusters);
        RUNTIME_INFO_FUNCTIONS.put("exporters", GlobalRuntime::getRuntimeExporters);
        RUNTIME_INFO_FUNCTIONS.put("servers", GlobalRuntime::getRuntimeServers);
        RUNTIME_INFO_FUNCTIONS.put("meshClients", GlobalRuntime::getRuntimeMeshClients);
        DEFAULT_KEYS.add("registries");
        DEFAULT_KEYS.add("clusters");
        DEFAULT_KEYS.add("exporters");
        DEFAULT_KEYS.add("servers");
        DEFAULT_KEYS.add("meshClients");
    }
}

