/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.admin;

import com.weibo.api.motan.admin.PermissionChecker;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.util.MotanGlobalConfigUtil;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import org.apache.commons.lang3.StringUtils;

public class DefaultPermissionChecker
implements PermissionChecker {
    public static final String ADMIN_DISABLE_SWITCHER = "feature.motan.admin.disable";
    protected String token;

    public DefaultPermissionChecker() {
        this.init();
    }

    @Override
    public boolean check(Request request) {
        String ip = request.getAttachment(URLParamType.host.getName());
        if ("127.0.0.1".equals(ip) || "::1".equals(ip) || "0:0:0:0:0:0:0:1".equals(ip)) {
            return true;
        }
        if (MotanSwitcherUtil.isOpen(ADMIN_DISABLE_SWITCHER)) {
            return false;
        }
        if (this.token != null && this.token.equals(this.getToken(request))) {
            return true;
        }
        return this.extendValidate(request);
    }

    protected boolean extendValidate(Request request) {
        return false;
    }

    protected String getToken(Request request) {
        String requestToken = request.getAttachment("Token");
        if (requestToken == null) {
            requestToken = request.getAttachment("token");
        }
        return requestToken;
    }

    private void init() {
        String token = System.getenv("MOTAN_ADMIN_TOKEN");
        if (StringUtils.isBlank((CharSequence)token)) {
            token = MotanGlobalConfigUtil.getConfig("admin.token");
        }
        if (token != null) {
            this.token = token.trim();
        }
        MotanSwitcherUtil.switcherIsOpenWithDefault(ADMIN_DISABLE_SWITCHER, false);
    }
}

