/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.util;

import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.util.LoggerUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetUtils.class);
    public static final String LOCALHOST = "127.0.0.1";
    private static volatile String LOCAL_IP_STRING;
    private static volatile InetAddress LOCAL_ADDRESS;
    private static final Pattern LOCAL_IP_PATTERN;
    private static final Pattern IP_PATTERN;

    public static boolean isInvalidLocalHost(String host) {
        return host == null || host.isEmpty() || host.equalsIgnoreCase("localhost") || host.equals("0.0.0.0") || LOCAL_IP_PATTERN.matcher(host).matches() || !IP_PATTERN.matcher(host).matches();
    }

    public static boolean isValidLocalHost(String host) {
        return !NetUtils.isInvalidLocalHost(host);
    }

    public static String getLocalIpString() {
        return NetUtils.getLocalIpString(null);
    }

    public static String getLocalIpString(Map<String, Integer> destHostPorts) {
        String envIp;
        if (LOCAL_IP_STRING != null) {
            return LOCAL_IP_STRING;
        }
        if (StringUtils.isNotBlank((CharSequence)System.getenv("MOTAN_LOCAL_IP")) && NetUtils.isValidLocalHost(envIp = System.getenv("MOTAN_LOCAL_IP").trim())) {
            LOCAL_IP_STRING = envIp;
            LoggerUtil.info("use env local IP:" + LOCAL_IP_STRING);
            return LOCAL_IP_STRING;
        }
        LOCAL_IP_STRING = NetUtils.getLocalAddress(destHostPorts).getHostAddress();
        return LOCAL_IP_STRING;
    }

    @Deprecated
    public static InetAddress getLocalAddress() {
        return NetUtils.getLocalAddress(null);
    }

    @Deprecated
    public static InetAddress getLocalAddress(Map<String, Integer> destHostPorts) {
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        InetAddress localAddress = null;
        String ipPrefix = System.getenv("MOTAN_IP_PREFIX");
        if (StringUtils.isNotBlank((CharSequence)ipPrefix)) {
            localAddress = NetUtils.getLocalAddressByNetworkInterface(ipPrefix);
            LoggerUtil.info("get local address by ip prefix: " + ipPrefix + ", address:" + localAddress);
        }
        if (!NetUtils.isValidAddress(localAddress)) {
            localAddress = NetUtils.getLocalAddressByHostname();
            LoggerUtil.info("get local address by hostname, address:" + localAddress);
        }
        if (!NetUtils.isValidAddress(localAddress)) {
            localAddress = NetUtils.getLocalAddressBySocket(destHostPorts);
            LoggerUtil.info("get local address by remote host. address:" + localAddress);
        }
        if (!NetUtils.isValidAddress(localAddress)) {
            localAddress = NetUtils.getLocalAddressByNetworkInterface(null);
            LoggerUtil.info("get local address from network interface. address:" + localAddress);
        }
        if (NetUtils.isValidAddress(localAddress)) {
            LOCAL_ADDRESS = localAddress;
            LoggerUtil.info("use " + localAddress + " as local IP");
            return localAddress;
        }
        throw new MotanFrameworkException("getLocalAddress fail, no valid local IP found");
    }

    private static InetAddress getLocalAddressByHostname() {
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            if (NetUtils.isValidAddress(localAddress)) {
                return localAddress;
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to retrieving local address by hostname:" + e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InetAddress getLocalAddressBySocket(Map<String, Integer> destHostPorts) {
        if (destHostPorts == null) return null;
        if (destHostPorts.isEmpty()) {
            return null;
        }
        Iterator<Map.Entry<String, Integer>> iterator = destHostPorts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Integer> entry = iterator.next();
            String host = entry.getKey();
            int port = entry.getValue();
            try (Socket socket = new Socket();){
                InetSocketAddress addr = new InetSocketAddress(host, port);
                socket.connect(addr, 1000);
                LoggerUtil.info("get local address from socket. remote host:" + host + ", port:" + port);
                InetAddress inetAddress = socket.getLocalAddress();
                return inetAddress;
            }
            catch (Exception e) {
                LoggerUtil.warn(String.format("Failed to retrieving local address by connecting to dest host:port(%s:%s) false, e=%s", host, port, e));
            }
        }
        return null;
    }

    private static InetAddress getLocalAddressByNetworkInterface(String prefix) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    try {
                        NetworkInterface network = interfaces.nextElement();
                        Enumeration<InetAddress> addresses = network.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            try {
                                InetAddress address = addresses.nextElement();
                                if (!NetUtils.isValidAddress(address)) continue;
                                if (StringUtils.isBlank((CharSequence)prefix)) {
                                    return address;
                                }
                                if (!address.getHostAddress().startsWith(prefix)) continue;
                                return address;
                            }
                            catch (Throwable e) {
                                logger.warn("Failed to retrieving ip address, " + e.getMessage(), e);
                            }
                        }
                    }
                    catch (Throwable e) {
                        logger.warn("Failed to retrieving ip address, " + e.getMessage(), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to retrieving ip address, " + e.getMessage(), e);
        }
        return null;
    }

    public static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        return NetUtils.isValidLocalHost(address.getHostAddress());
    }

    public static String getHostName(SocketAddress socketAddress) {
        InetAddress addr;
        if (socketAddress == null) {
            return null;
        }
        if (socketAddress instanceof InetSocketAddress && (addr = ((InetSocketAddress)socketAddress).getAddress()) != null) {
            return addr.getHostAddress();
        }
        return null;
    }

    public static void clearCache() {
        LOCAL_IP_STRING = null;
    }

    static {
        LOCAL_ADDRESS = null;
        LOCAL_IP_PATTERN = Pattern.compile("127(\\.\\d{1,3}){3}$");
        IP_PATTERN = Pattern.compile("^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
    }
}

