/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.util;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.RegistryConfig;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.Traceable;
import com.weibo.api.motan.rpc.TraceableContext;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.switcher.Switcher;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MotanFrameworkUtil {
    private static Switcher MOTAN_TRACE_INFO_SW = null;

    public static String getServiceKey(Request request) {
        String version = MotanFrameworkUtil.getVersionFromRequest(request);
        String group = MotanFrameworkUtil.getGroupFromRequest(request);
        return MotanFrameworkUtil.getServiceKey(group, request.getInterfaceName(), version);
    }

    public static String getGroupFromRequest(Request request) {
        return MotanFrameworkUtil.getValueFromRequest(request, URLParamType.group.name(), URLParamType.group.getValue());
    }

    public static String getVersionFromRequest(Request request) {
        return MotanFrameworkUtil.getValueFromRequest(request, URLParamType.version.name(), URLParamType.version.getValue());
    }

    public static String getRemoteIpFromRequest(Request request) {
        String rip = MotanFrameworkUtil.getValueFromRequest(request, "x-forwarded-for", null);
        if (rip == null) {
            rip = MotanFrameworkUtil.getValueFromRequest(request, URLParamType.host.getName(), null);
        }
        return rip;
    }

    public static String getValueFromRequest(Request request, String key, String defaultValue) {
        String value = defaultValue;
        if (request.getAttachments() != null && request.getAttachments().containsKey(key)) {
            value = request.getAttachments().get(key);
        }
        return value;
    }

    public static String getServiceKey(URL url) {
        return MotanFrameworkUtil.getServiceKey(url.getGroup(), url.getPath(), url.getVersion());
    }

    public static String getProtocolKey(URL url) {
        return url.getProtocol() + "://" + url.getServerPortStr() + "/" + url.getGroup() + "/" + url.getPath() + "/" + url.getVersion();
    }

    public static String toString(Request request) {
        return "requestId=" + request.getRequestId() + " interface=" + request.getInterfaceName() + " method=" + request.getMethodName() + "(" + request.getParamtersDesc() + ")";
    }

    public static String toStringWithRemoteIp(Request request) {
        return MotanFrameworkUtil.toString(request) + " remoteIp=" + MotanFrameworkUtil.getRemoteIpFromRequest(request);
    }

    public static String getFullMethodString(Request request) {
        return request.getInterfaceName() + "." + request.getMethodName() + "(" + request.getParamtersDesc() + ")";
    }

    public static String getGroupMethodString(Request request) {
        return MotanFrameworkUtil.getGroupFromRequest(request) + "_" + MotanFrameworkUtil.getFullMethodString(request);
    }

    public static String getModuleOrGroup(Map<String, String> map, String defaultValue) {
        if (map != null) {
            String module = map.get(URLParamType.module.getName());
            if (module == null) {
                module = map.get(URLParamType.group.getName());
            }
            if (module != null) {
                return module;
            }
        }
        return defaultValue;
    }

    public static boolean checkIfCanShareServiceChannel(URL source, URL target) {
        if (!StringUtils.equals((CharSequence)source.getProtocol(), (CharSequence)target.getProtocol())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.codec.getName()), (CharSequence)target.getParameter(URLParamType.codec.getName()))) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.serialize.getName()), (CharSequence)target.getParameter(URLParamType.serialize.getName()))) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.maxContentLength.getName()), (CharSequence)target.getParameter(URLParamType.maxContentLength.getName()))) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.maxServerConnection.getName()), (CharSequence)target.getParameter(URLParamType.maxServerConnection.getName()))) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.maxWorkerThread.getName()), (CharSequence)target.getParameter(URLParamType.maxWorkerThread.getName()))) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.workerQueueSize.getName()), (CharSequence)target.getParameter(URLParamType.workerQueueSize.getName()))) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.heartbeatFactory.getName()), (CharSequence)target.getParameter(URLParamType.heartbeatFactory.getName()))) {
            return false;
        }
        return StringUtils.equals((CharSequence)source.getParameter(URLParamType.providerProtectedStrategy.getName()), (CharSequence)target.getParameter(URLParamType.providerProtectedStrategy.getName()));
    }

    public static boolean checkIfCanShallClientChannel(URL source, URL target) {
        if (!StringUtils.equals((CharSequence)source.getProtocol(), (CharSequence)target.getProtocol())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.codec.getName()), (CharSequence)target.getParameter(URLParamType.codec.getName()))) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.serialize.getName()), (CharSequence)target.getParameter(URLParamType.serialize.getName()))) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.maxContentLength.getName()), (CharSequence)target.getParameter(URLParamType.maxContentLength.getName()))) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.maxClientConnection.getName()), (CharSequence)target.getParameter(URLParamType.maxClientConnection.getName()))) {
            return false;
        }
        return StringUtils.equals((CharSequence)source.getParameter(URLParamType.heartbeatFactory.getName()), (CharSequence)target.getParameter(URLParamType.heartbeatFactory.getName()));
    }

    private static String getServiceKey(String group, String interfaceName, String version) {
        return group + "/" + interfaceName + "/" + version;
    }

    public static ProtocolConfig getDefaultProtocolConfig() {
        ProtocolConfig pc = new ProtocolConfig();
        pc.setId("motan");
        pc.setName("motan");
        return pc;
    }

    public static RegistryConfig getDefaultRegistryConfig() {
        RegistryConfig local = new RegistryConfig();
        local.setRegProtocol("local");
        return local;
    }

    public static String removeAsyncSuffix(String path) {
        if (path != null && path.endsWith("Async")) {
            return path.substring(0, path.length() - "Async".length());
        }
        return path;
    }

    public static DefaultResponse buildErrorResponse(Request request, Exception e) {
        return MotanFrameworkUtil.buildErrorResponse(request.getRequestId(), request.getRpcProtocolVersion(), e);
    }

    public static DefaultResponse buildErrorResponse(long requestId, byte version, Exception e) {
        DefaultResponse response = new DefaultResponse();
        response.setRequestId(requestId);
        response.setRpcProtocolVersion(version);
        response.setException(e);
        return response;
    }

    public static void logEvent(Request request, String event) {
        if (MotanSwitcherUtil.isOpen(MOTAN_TRACE_INFO_SW, "feature.motan.trace.info")) {
            MotanFrameworkUtil.logEvent(request, event, System.currentTimeMillis());
        }
    }

    public static void logEvent(Request request, String event, long time) {
        if (!(request instanceof Traceable)) {
            return;
        }
        TraceableContext context = ((Traceable)((Object)request)).getTraceableContext();
        if ("TRACE_CSEND".equals(event)) {
            context.setSendTime(time);
            return;
        }
        if ("TRACE_SRECEIVE".equals(event)) {
            context.setReceiveTime(time);
            return;
        }
        if (MotanSwitcherUtil.isOpen(MOTAN_TRACE_INFO_SW, "feature.motan.trace.info")) {
            context.addTraceInfo(event, String.valueOf(time));
        }
    }

    public static void logEvent(Response response, String event) {
        if (MotanSwitcherUtil.isOpen(MOTAN_TRACE_INFO_SW, "feature.motan.trace.info")) {
            MotanFrameworkUtil.logEvent(response, event, System.currentTimeMillis());
        }
    }

    public static void logEvent(Response response, String event, long time) {
        if (!(response instanceof Traceable)) {
            return;
        }
        TraceableContext context = ((Traceable)((Object)response)).getTraceableContext();
        if ("TRACE_SSEND".equals(event)) {
            context.setSendTime(time);
            return;
        }
        if ("TRACE_CRECEIVE".equals(event)) {
            context.setReceiveTime(time);
            return;
        }
        if (MotanSwitcherUtil.isOpen(MOTAN_TRACE_INFO_SW, "feature.motan.trace.info")) {
            context.addTraceInfo(event, String.valueOf(time));
        }
    }

    static {
        if (MotanSwitcherUtil.canHoldSwitcher()) {
            MOTAN_TRACE_INFO_SW = MotanSwitcherUtil.getOrInitSwitcher("feature.motan.trace.info", false);
        } else {
            MotanSwitcherUtil.switcherIsOpenWithDefault("feature.motan.trace.info", false);
        }
    }
}

