/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport;

import com.weibo.api.motan.common.ChannelState;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.DefaultThreadFactory;
import com.weibo.api.motan.core.StandardThreadExecutor;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.AbstractClient;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.SharedObjectFactory;
import com.weibo.api.motan.util.CollectionUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MathUtil;
import java.util.ArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractSharedPoolClient
extends AbstractClient {
    private static final ThreadPoolExecutor EXECUTOR = new StandardThreadExecutor(1, 300, 20000, new DefaultThreadFactory("AbstractPoolClient-initPool-", true));
    private final AtomicInteger idx = new AtomicInteger();
    protected SharedObjectFactory factory;
    protected ArrayList<Channel> channels;
    protected int connections;
    protected volatile boolean poolInit;

    public AbstractSharedPoolClient(URL url) {
        super(url);
        this.connections = url.getIntParameter(URLParamType.minClientConnection.getName(), URLParamType.minClientConnection.getIntValue());
        if (this.connections <= 0) {
            this.connections = URLParamType.minClientConnection.getIntValue();
        }
    }

    protected void initPool() {
        this.factory = this.createChannelFactory();
        this.channels = new ArrayList(this.connections);
        for (int i = 0; i < this.connections; ++i) {
            this.channels.add((Channel)this.factory.makeObject());
        }
        if (this.url.getBooleanParameter(URLParamType.lazyInit.getName(), URLParamType.lazyInit.getBooleanValue()).booleanValue()) {
            this.state = ChannelState.ALIVE;
            LoggerUtil.debug("motan client will be lazily initialized. url:" + this.url.getUri());
            return;
        }
        this.initConnections(this.url.getBooleanParameter(URLParamType.asyncInitConnection.getName(), URLParamType.asyncInitConnection.getBooleanValue()));
    }

    protected abstract SharedObjectFactory createChannelFactory();

    protected void initConnections(boolean async) {
        if (async) {
            EXECUTOR.execute(() -> {
                this.createConnections();
                LoggerUtil.info("async initPool {}. url:{}", this.state == ChannelState.ALIVE ? "success" : "fail", this.getUrl().getUri());
            });
        } else {
            this.createConnections();
        }
    }

    private void createConnections() {
        for (Channel channel : this.channels) {
            try {
                channel.open();
                this.state = ChannelState.ALIVE;
            }
            catch (Exception e) {
                LoggerUtil.error("NettyClient init pool create connect Error: url=" + this.url.getUri(), e);
            }
        }
        this.poolInit = true;
        if (this.state == ChannelState.UNINIT) {
            this.state = ChannelState.UNALIVE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Channel getChannel() {
        int index;
        if (!this.poolInit) {
            AbstractSharedPoolClient abstractSharedPoolClient = this;
            synchronized (abstractSharedPoolClient) {
                if (!this.poolInit) {
                    this.createConnections();
                }
            }
        }
        for (int i = index = MathUtil.getNonNegativeRange24bit(this.idx.getAndIncrement()); i < this.connections + index; ++i) {
            Channel channel = this.channels.get(i % this.connections);
            if (!channel.isAvailable()) {
                this.factory.rebuildObject(channel, i != this.connections + index - 1);
            }
            if (!channel.isAvailable()) continue;
            return channel;
        }
        String errorMsg = this.getClass().getSimpleName() + " getChannel Error: url=" + this.url.getUri();
        throw new MotanServiceException(errorMsg);
    }

    protected void closeAllChannels() {
        if (!CollectionUtil.isEmpty(this.channels)) {
            for (Channel channel : this.channels) {
                channel.close();
            }
        }
    }
}

