/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanBizException;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.AbstractProvider;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.ResponseFuture;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.ExceptionUtil;
import com.weibo.api.motan.util.LoggerUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

@SpiMeta(name="motan")
public class DefaultProvider<T>
extends AbstractProvider<T> {
    protected T proxyImpl;
    protected boolean isAsync = false;

    public DefaultProvider(T proxyImpl, URL url, Class<T> clz) {
        super(url, clz);
        this.proxyImpl = proxyImpl;
        Class<?> asyncInterface = null;
        try {
            asyncInterface = Class.forName(clz.getName() + "Async");
            if (asyncInterface.isInterface() && asyncInterface.isAssignableFrom(proxyImpl.getClass())) {
                this.isAsync = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isAsync) {
            this.initMethodMap(asyncInterface);
        } else {
            this.initMethodMap(clz);
        }
    }

    @Override
    public T getImpl() {
        return this.proxyImpl;
    }

    @Override
    public Response invoke(Request request) {
        boolean transExceptionStack;
        Method method;
        DefaultResponse response = new DefaultResponse();
        String methodName = request.getMethodName();
        if (this.isAsync) {
            methodName = methodName + "Async";
        }
        if ((method = this.lookupMethod(methodName, request.getParamtersDesc())) == null) {
            LoggerUtil.error("can not found rpc method:" + request.getMethodName() + ", paramDesc:" + request.getParamtersDesc() + ", service:" + request.getInterfaceName());
            MotanServiceException exception = new MotanServiceException("Service method not exist: " + request.getInterfaceName() + "." + request.getMethodName() + "(" + request.getParamtersDesc() + ")", MotanErrorMsgConstant.SERVICE_UNFOUND, false);
            response.setException(exception);
            return response;
        }
        boolean defaultThrowExceptionStack = URLParamType.transExceptionStack.getBooleanValue();
        try {
            Object value = method.invoke(this.proxyImpl, request.getArguments());
            if (value instanceof ResponseFuture) {
                return (Response)value;
            }
            response.setValue(value);
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                response.setException(new MotanBizException("provider call process error", e.getCause()));
            } else {
                response.setException(new MotanBizException("provider call process error", e));
            }
            boolean logException = true;
            for (Class<?> clazz : method.getExceptionTypes()) {
                if (!clazz.isInstance(response.getException().getCause())) continue;
                logException = false;
                defaultThrowExceptionStack = false;
                break;
            }
            if (logException) {
                LoggerUtil.error("Exception caught when during method invocation. request:" + request, e);
            } else {
                LoggerUtil.info("Exception caught when during method invocation. request:" + request + ", exception:" + response.getException().getCause().toString());
            }
        }
        catch (Throwable t) {
            if (t.getCause() != null) {
                response.setException(new MotanServiceException("provider has encountered a fatal error!", t.getCause()));
            } else {
                response.setException(new MotanServiceException("provider has encountered a fatal error!", t));
            }
            LoggerUtil.error("Exception caught when during method invocation. request:" + request, t);
        }
        if (response.getException() != null && !(transExceptionStack = this.url.getBooleanParameter(URLParamType.transExceptionStack.getName(), defaultThrowExceptionStack).booleanValue())) {
            ExceptionUtil.setMockStackTrace(response.getException().getCause());
        }
        return response;
    }

    @Override
    public Map<String, Object> getRuntimeInfo() {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("service", this.clz.getName());
        infos.put("isAsync", this.isAsync);
        infos.put("implClass", this.proxyImpl.getClass().getName());
        return infos;
    }
}

