/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.proxy;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.DefaultRequest;
import com.weibo.api.motan.rpc.DefaultResponseFuture;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.ResponseFuture;
import com.weibo.api.motan.rpc.RpcContext;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.serialize.DeserializableObject;
import com.weibo.api.motan.switcher.Switcher;
import com.weibo.api.motan.switcher.SwitcherService;
import com.weibo.api.motan.util.ExceptionUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import com.weibo.api.motan.util.ReflectUtil;
import com.weibo.api.motan.util.RequestIdGenerator;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AbstractRefererHandler<T> {
    protected List<Caller<T>> callers;
    protected Class<T> clz;
    protected SwitcherService switcherService = null;
    protected String interfaceName;
    protected URL url;
    protected boolean isSingleCluster = false;

    void init() {
        this.url = this.callers.get(0).getUrl();
        this.isSingleCluster = this.callers.size() == 1;
    }

    Object invokeRequest(Request request, Class<?> returnType, boolean async) throws Throwable {
        this.fillWithContext(request, async);
        request.setAttachment(URLParamType.version.getName(), this.url.getVersion());
        request.setAttachment(URLParamType.clientGroup.getName(), this.url.getGroup());
        request.setAttachment(URLParamType.application.getName(), this.url.getApplication());
        request.setAttachment(URLParamType.module.getName(), this.url.getModule());
        if (this.isSingleCluster) {
            return this.call(this.callers.get(0), this.url, request, returnType, async);
        }
        for (Caller<T> caller : this.callers) {
            String protocolSwitcher = "protocol:" + caller.getUrl().getProtocol();
            Switcher switcher = MotanSwitcherUtil.getSwitcher(protocolSwitcher);
            if (switcher != null && !switcher.isOn()) continue;
            return this.call(caller, caller.getUrl(), request, returnType, async);
        }
        throw new MotanServiceException("Referer call Error: cluster not exist, interface=" + this.interfaceName + " " + MotanFrameworkUtil.toString(request), MotanErrorMsgConstant.SERVICE_UNFOUND, false);
    }

    protected Object call(Caller<T> caller, URL refUrl, Request request, Class<?> returnType, boolean async) throws Throwable {
        boolean throwException = Boolean.parseBoolean(refUrl.getParameter(URLParamType.throwException.getName(), URLParamType.throwException.getValue()));
        try {
            MotanFrameworkUtil.logEvent(request, "TRACE_INVOKE");
            Response response = caller.call(request);
            if (async) {
                if (response instanceof ResponseFuture) {
                    ((ResponseFuture)response).setReturnType(returnType);
                    return response;
                }
                DefaultResponseFuture responseFuture = new DefaultResponseFuture(request, 0, refUrl);
                if (response.getException() != null) {
                    responseFuture.onFailure(response);
                } else {
                    responseFuture.onSuccess(response);
                }
                responseFuture.setReturnType(returnType);
                return responseFuture;
            }
            Object value = response.getValue();
            if (value instanceof DeserializableObject) {
                try {
                    value = ((DeserializableObject)value).deserialize(returnType);
                }
                catch (IOException e) {
                    LoggerUtil.error("deserialize response value fail! deserialize type:" + returnType, e);
                    throw new MotanFrameworkException("deserialize return value fail! deserialize type:" + returnType, e);
                }
            }
            return value;
        }
        catch (RuntimeException e) {
            if (ExceptionUtil.isBizException(e)) {
                Throwable t = e.getCause();
                if (t instanceof Exception) {
                    throw t;
                }
                String msg = t == null ? "biz exception cause is null. origin error msg : " + e.getMessage() : "biz exception cause is throwable error:" + t.getClass() + ", errMsg:" + t.getMessage();
                throw new MotanServiceException(msg);
            }
            if (!throwException) {
                LoggerUtil.warn("RefererInvocationHandler invoke false, so return default value: uri=" + refUrl.getUri() + " " + MotanFrameworkUtil.toString(request), e);
                return this.getDefaultReturnValue(returnType);
            }
            LoggerUtil.error("RefererInvocationHandler invoke Error: uri=" + refUrl.getUri() + " " + MotanFrameworkUtil.toString(request), e);
            throw e;
        }
    }

    protected boolean isLocalMethod(Method method) {
        if (method.getDeclaringClass().equals(Object.class)) {
            try {
                this.clz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                return false;
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    protected boolean fillDefaultRequest(DefaultRequest request, Method method, Object[] args) {
        request.setRequestId(RequestIdGenerator.getRequestId());
        request.setArguments(args);
        String methodName = method.getName();
        boolean async = false;
        if (methodName.endsWith("Async") && method.getReturnType().equals(ResponseFuture.class)) {
            methodName = MotanFrameworkUtil.removeAsyncSuffix(methodName);
            async = true;
        }
        request.setMethodName(methodName);
        request.setParamtersDesc(ReflectUtil.getMethodParamDesc(method));
        request.setInterfaceName(this.interfaceName);
        return async;
    }

    protected Class<?> getRealReturnType(boolean asyncCall, Class<?> clazz, Method method, String methodName) {
        if (asyncCall) {
            try {
                Method m = clazz.getMethod(methodName, method.getParameterTypes());
                return m.getReturnType();
            }
            catch (Exception e) {
                LoggerUtil.warn("RefererInvocationHandler get real return type fail. err:" + e.getMessage());
                return method.getReturnType();
            }
        }
        return method.getReturnType();
    }

    protected void fillWithContext(Request request, boolean async) {
        RpcContext curContext = RpcContext.getContext();
        curContext.putAttribute("Async", async);
        Map<String, String> attachments = curContext.getRpcAttachments();
        if (!attachments.isEmpty()) {
            for (Map.Entry<String, String> entry : attachments.entrySet()) {
                request.setAttachment(entry.getKey(), entry.getValue());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)curContext.getClientRequestId())) {
            request.setAttachment(URLParamType.requestIdFromClient.getName(), curContext.getClientRequestId());
        }
    }

    protected Object getDefaultReturnValue(Class<?> returnType) {
        if (returnType != null && returnType.isPrimitive()) {
            return PrimitiveDefault.getDefaultReturnValue(returnType);
        }
        return null;
    }

    private static class PrimitiveDefault {
        private static boolean defaultBoolean;
        private static char defaultChar;
        private static byte defaultByte;
        private static short defaultShort;
        private static int defaultInt;
        private static long defaultLong;
        private static float defaultFloat;
        private static double defaultDouble;
        private static final Map<Class<?>, Object> primitiveValues;

        private PrimitiveDefault() {
        }

        public static Object getDefaultReturnValue(Class<?> returnType) {
            return primitiveValues.get(returnType);
        }

        static {
            primitiveValues = new HashMap();
            primitiveValues.put(Boolean.TYPE, defaultBoolean);
            primitiveValues.put(Character.TYPE, Character.valueOf(defaultChar));
            primitiveValues.put(Byte.TYPE, defaultByte);
            primitiveValues.put(Short.TYPE, defaultShort);
            primitiveValues.put(Integer.TYPE, defaultInt);
            primitiveValues.put(Long.TYPE, defaultLong);
            primitiveValues.put(Float.TYPE, Float.valueOf(defaultFloat));
            primitiveValues.put(Double.TYPE, defaultDouble);
        }
    }
}

