/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.config.AbstractServiceConfig;
import com.weibo.api.motan.config.BasicServiceInterfaceConfig;
import com.weibo.api.motan.config.ConfigUtil;
import com.weibo.api.motan.config.MethodConfig;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.annotation.ConfigDesc;
import com.weibo.api.motan.config.handler.ConfigHandler;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.registry.RegistryService;
import com.weibo.api.motan.rpc.Exporter;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.runtime.GlobalRuntime;
import com.weibo.api.motan.util.ConcurrentHashSet;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MetaUtil;
import com.weibo.api.motan.util.NetUtils;
import com.weibo.api.motan.util.StringTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ServiceConfig<T>
extends AbstractServiceConfig {
    private static final long serialVersionUID = -3342374271064293224L;
    private static final ConcurrentHashSet<String> existingServices = new ConcurrentHashSet();
    private static final AtomicBoolean initEnv = new AtomicBoolean(false);
    private static final Map<Pattern, String> serviceGroupMapFromEnv = new HashMap<Pattern, String>();
    protected List<MethodConfig> methods;
    private T ref;
    private final List<Exporter<T>> exporters = new CopyOnWriteArrayList<Exporter<T>>();
    private Class<T> interfaceClass;
    private BasicServiceInterfaceConfig basicService;
    private final AtomicBoolean exported = new AtomicBoolean(false);

    public static ConcurrentHashSet<String> getExistingServices() {
        return existingServices;
    }

    public Class<?> getInterface() {
        return this.interfaceClass;
    }

    public void setInterface(Class<T> interfaceClass) {
        if (interfaceClass != null && !interfaceClass.isInterface()) {
            throw new IllegalStateException("The interface class " + interfaceClass + " is not a interface!");
        }
        this.interfaceClass = interfaceClass;
    }

    public List<MethodConfig> getMethods() {
        return this.methods;
    }

    public void setMethods(MethodConfig methods) {
        this.methods = Collections.singletonList(methods);
    }

    public void setMethods(List<MethodConfig> methods) {
        this.methods = methods;
    }

    public boolean hasMethods() {
        return this.methods != null && !this.methods.isEmpty();
    }

    public T getRef() {
        return this.ref;
    }

    public void setRef(T ref) {
        this.ref = ref;
    }

    public List<Exporter<T>> getExporters() {
        return Collections.unmodifiableList(this.exporters);
    }

    protected boolean serviceExists(URL url) {
        return existingServices.contains(url.getIdentity());
    }

    public synchronized void export() {
        if (this.exported.get()) {
            LoggerUtil.warn(String.format("%s has already been exported, so ignore the export request!", this.interfaceClass.getName()));
            return;
        }
        this.checkInterfaceAndMethods(this.interfaceClass, this.methods);
        this.loadRegistryUrls();
        if (this.registryUrls == null || this.registryUrls.isEmpty()) {
            throw new IllegalStateException("Should set registry config for service:" + this.interfaceClass.getName());
        }
        Map<String, Integer> protocolPorts = this.getProtocolAndPort();
        for (ProtocolConfig protocolConfig : this.protocols) {
            Integer port = protocolPorts.get(protocolConfig.getId());
            if (port == null) {
                throw new MotanServiceException(String.format("Unknown port in service:%s, protocol:%s", this.interfaceClass.getName(), protocolConfig.getId()));
            }
            this.doExport(protocolConfig, port);
        }
        this.afterExport();
    }

    public synchronized void unexport() {
        if (!this.exported.get()) {
            return;
        }
        try {
            ConfigHandler configHandler = ExtensionLoader.getExtensionLoader(ConfigHandler.class).getExtension("default");
            configHandler.unexport(this.exporters, this.registryUrls);
        }
        finally {
            this.afterUnexport();
        }
    }

    private void doExport(ProtocolConfig protocolConfig, int port) {
        String serverMode;
        String hostAddress;
        String protocolName = protocolConfig.getName();
        if (protocolName == null || protocolName.isEmpty()) {
            protocolName = URLParamType.protocol.getValue();
        }
        if (StringUtils.isBlank((CharSequence)(hostAddress = this.host)) && this.basicService != null) {
            hostAddress = this.basicService.getHost();
        }
        if (NetUtils.isInvalidLocalHost(hostAddress)) {
            hostAddress = this.getLocalHostAddress();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(URLParamType.nodeType.getName(), "service");
        map.put(URLParamType.refreshTimestamp.getName(), String.valueOf(System.currentTimeMillis()));
        ServiceConfig.collectConfigParams(map, protocolConfig, this.basicService, this.extConfig, this);
        ServiceConfig.collectMethodConfigParams(map, this.getMethods());
        URL serviceUrl = new URL(protocolName, hostAddress, port, this.interfaceClass.getName(), map);
        if (serviceUrl.getBooleanParameter(URLParamType.registerMeta.getName(), URLParamType.registerMeta.getBooleanValue()).booleanValue()) {
            MetaUtil.addStaticMeta(serviceUrl);
        }
        String groupString = serviceUrl.getParameter(URLParamType.group.getName(), "");
        String additionalGroup = System.getenv("MOTAN_SERVICE_ADDITIONAL_GROUP");
        if (StringUtils.isNotBlank((CharSequence)additionalGroup)) {
            groupString = StringUtils.isBlank((CharSequence)groupString) ? additionalGroup : groupString + "," + additionalGroup;
            serviceUrl.addParameter(URLParamType.group.getName(), groupString);
        }
        if ("sandbox".equals(serverMode = System.getenv("MOTAN_SERVER_MODE"))) {
            String changeGroups;
            LoggerUtil.info("motan server start in sandbox mode.");
            if (!initEnv.get()) {
                this.initChangeGroupEnv();
            }
            if ((changeGroups = this.getChangeGroupFromEnv(serviceUrl.getPath())) == null) {
                changeGroups = serviceUrl.getParameter(URLParamType.sandboxGroups.getName(), "");
            }
            if (StringUtils.isBlank((CharSequence)changeGroups)) {
                LoggerUtil.error("can not find sandbox group name in sandbox mode. service url:" + serviceUrl.toSimpleString());
                throw new MotanServiceException("can not find sandbox group name in sandbox mode. service url:" + serviceUrl.toSimpleString());
            }
            groupString = changeGroups.replace("suffix:", serviceUrl.getGroup());
            serviceUrl.addParameter(URLParamType.group.getName(), groupString);
            LoggerUtil.info("change register group in sandbox mode, serviceUrl:" + serviceUrl.toSimpleString() + ", change to groups:" + groupString);
        }
        if (groupString.contains(",")) {
            for (String group : StringTools.splitSet(groupString, ",")) {
                URL newGroupServiceUrl = serviceUrl.createCopy();
                newGroupServiceUrl.addParameter(URLParamType.group.getName(), group);
                this.exportService(hostAddress, protocolName, newGroupServiceUrl);
            }
        } else {
            this.exportService(hostAddress, protocolName, serviceUrl);
        }
    }

    private synchronized void initChangeGroupEnv() {
        if (!initEnv.get()) {
            String changeGroups = System.getenv("MOTAN_CHANGE_REG_GROUPS");
            if (StringUtils.isNotBlank((CharSequence)changeGroups)) {
                LoggerUtil.info("init env MOTAN_CHANGE_REG_GROUPS, value:" + changeGroups);
                try {
                    JSONArray configs = JSON.parseArray((String)changeGroups);
                    for (Object config : configs) {
                        JSONObject configJson = (JSONObject)config;
                        String group = configJson.getString("group");
                        String service = configJson.getString("service");
                        if (!StringUtils.isNotBlank((CharSequence)group) || !StringUtils.isNotBlank((CharSequence)service)) continue;
                        serviceGroupMapFromEnv.put(Pattern.compile(service), group);
                        LoggerUtil.info(String.format("add change group env, service:%s, group:%s", service, group));
                    }
                }
                catch (Exception e) {
                    LoggerUtil.error("parse env MOTAN_CHANGE_REG_GROUPS fail, value:" + changeGroups, e);
                }
            }
            initEnv.set(true);
        }
    }

    private String getChangeGroupFromEnv(String service) {
        for (Map.Entry<Pattern, String> entry : serviceGroupMapFromEnv.entrySet()) {
            if (!entry.getKey().matcher(service).matches()) continue;
            return entry.getValue();
        }
        return null;
    }

    protected static void clearChangeGroupFromEnv() {
        serviceGroupMapFromEnv.clear();
        initEnv.set(false);
    }

    private void exportService(String hostAddress, String protocol, URL serviceUrl) {
        String appendSuffix = System.getenv("RPC_REG_GROUP_SUFFIX");
        if (StringUtils.isNotBlank((CharSequence)appendSuffix) && !serviceUrl.getGroup().endsWith(appendSuffix) && !"injvm".equals(protocol)) {
            serviceUrl.addParameter(URLParamType.group.getName(), serviceUrl.getGroup() + appendSuffix);
        }
        if (this.serviceExists(serviceUrl)) {
            LoggerUtil.warn(String.format("%s configService is malformed, for same service (%s) already exists ", this.interfaceClass.getName(), serviceUrl.getIdentity()));
            return;
        }
        LoggerUtil.info("export for service url :" + serviceUrl.toFullStr());
        ArrayList<URL> urls = new ArrayList<URL>();
        if ("injvm".equals(protocol)) {
            Object localRegistryUrl = null;
            for (URL ru : this.registryUrls) {
                if (!"local".equals(ru.getProtocol())) continue;
                localRegistryUrl = ru.createCopy();
                break;
            }
            if (localRegistryUrl == null) {
                localRegistryUrl = new URL("local", hostAddress, 0, RegistryService.class.getName());
            }
            urls.add((URL)localRegistryUrl);
        } else {
            for (URL ru : this.registryUrls) {
                urls.add(ru.createCopy());
            }
        }
        ConfigHandler configHandler = ExtensionLoader.getExtensionLoader(ConfigHandler.class).getExtension("default");
        this.exporters.add(configHandler.export(this.interfaceClass, this.ref, urls, serviceUrl));
    }

    private void afterExport() {
        this.exported.set(true);
        for (Exporter<T> ep : this.exporters) {
            String id = ep.getProvider().getUrl().getIdentity();
            existingServices.add(id);
            GlobalRuntime.addExporter(id, ep);
        }
    }

    private void afterUnexport() {
        this.exported.set(false);
        for (Exporter<T> ep : this.exporters) {
            String id = ep.getProvider().getUrl().getIdentity();
            existingServices.remove(id);
            GlobalRuntime.removeExporter(id);
        }
        this.exporters.clear();
    }

    @ConfigDesc(excluded=true)
    public BasicServiceInterfaceConfig getBasicService() {
        return this.basicService;
    }

    public void setBasicService(BasicServiceInterfaceConfig basicService) {
        this.basicService = basicService;
    }

    public Map<String, Integer> getProtocolAndPort() {
        if (StringUtils.isBlank((CharSequence)this.export)) {
            throw new MotanServiceException("export should not empty in service config:" + this.interfaceClass.getName());
        }
        return ConfigUtil.parseExport(this.export);
    }

    @Override
    @ConfigDesc(excluded=true)
    public String getHost() {
        return this.host;
    }

    public AtomicBoolean getExported() {
        return this.exported;
    }
}

