/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.cluster.group;

import com.weibo.api.motan.cluster.Cluster;
import com.weibo.api.motan.cluster.group.ClusterGroup;
import com.weibo.api.motan.cluster.group.ClusterSelector;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.util.CollectionUtil;
import java.util.List;

@SpiMeta(name="default")
public class DefaultClusterSelector<T>
implements ClusterSelector<T> {
    public static final String DEFAULT_ROUTE_GROUP_SANDBOX = "sandbox";
    protected ClusterGroup<T> clusterGroup;
    protected Cluster<T> defaultSandboxCluster;

    @Override
    public Cluster<T> select(Request request) {
        String routeGroup;
        if (this.defaultSandboxCluster != null && !CollectionUtil.isEmpty(this.defaultSandboxCluster.getReferers()) && (routeGroup = request.getAttachment("motan-route-group")) != null) {
            if (DEFAULT_ROUTE_GROUP_SANDBOX.equals(routeGroup = routeGroup.trim())) {
                return this.defaultSandboxCluster;
            }
            String[] routeGroupList = routeGroup.split(",");
            String ownGroup = this.clusterGroup.getUrl().getGroup();
            for (String group : routeGroupList) {
                if (!(group = group.trim()).equals(ownGroup)) continue;
                return this.defaultSandboxCluster;
            }
        }
        return this.clusterGroup.getMasterCluster();
    }

    @Override
    public void init(ClusterGroup<T> clusterGroup) {
        if (clusterGroup == null) {
            throw new MotanFrameworkException("ClusterGroup cannot be null");
        }
        this.clusterGroup = clusterGroup;
        List<Cluster<T>> sandboxClusters = clusterGroup.getSandboxClusters();
        if (!CollectionUtil.isEmpty(sandboxClusters)) {
            this.defaultSandboxCluster = sandboxClusters.get(0);
        }
    }

    @Override
    public void destroy() {
    }
}

