/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.util;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.DefaultThreadFactory;
import com.weibo.api.motan.core.StandardThreadExecutor;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.rpc.DefaultResponseFuture;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.ResponseFuture;
import com.weibo.api.motan.rpc.RpcContext;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AsyncUtil {
    private static final int DEFAULT_ASYNC_TIMEOUT = 1000;
    private static ThreadPoolExecutor defaultCallbackExecutor = new StandardThreadExecutor(20, 200, 60000L, TimeUnit.MILLISECONDS, 5000, (ThreadFactory)new DefaultThreadFactory("defaultResponseCallbackPool-", true), (RejectedExecutionHandler)new ThreadPoolExecutor.DiscardPolicy());

    public static synchronized void setDefaultCallbackExecutor(ThreadPoolExecutor defaultCallbackExecutor) {
        if (defaultCallbackExecutor == null) {
            throw new MotanFrameworkException("defaultCallbackExecutor cannot be null");
        }
        ThreadPoolExecutor temp = AsyncUtil.defaultCallbackExecutor;
        AsyncUtil.defaultCallbackExecutor = defaultCallbackExecutor;
        temp.shutdown();
    }

    public static ThreadPoolExecutor getDefaultCallbackExecutor() {
        return defaultCallbackExecutor;
    }

    public static ResponseFuture createResponseFutureForServerEnd() {
        Request request = RpcContext.getContext().getRequest();
        if (request == null) {
            throw new MotanFrameworkException("can not get request from RpcContext");
        }
        return new DefaultResponseFuture(request, 1000, request.getAttachment(URLParamType.host.getName()));
    }
}

