/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.support;

import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.rpc.DefaultRequest;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.HeartbeatFactory;
import com.weibo.api.motan.transport.MessageHandler;
import com.weibo.api.motan.util.RequestIdGenerator;
import java.util.Map;

@SpiMeta(name="motan")
public class DefaultRpcHeartbeatFactory
implements HeartbeatFactory {
    @Override
    public Request createRequest() {
        return DefaultRpcHeartbeatFactory.getDefaultHeartbeatRequest(RequestIdGenerator.getRequestId());
    }

    @Override
    public MessageHandler wrapMessageHandler(MessageHandler handler) {
        return new HeartMessageHandleWrapper(handler);
    }

    public static Request getDefaultHeartbeatRequest(long requestId) {
        HeartbeatRequest request = new HeartbeatRequest();
        request.setRequestId(requestId);
        request.setInterfaceName("com.weibo.api.motan.rpc.heartbeat");
        request.setMethodName("heartbeat");
        request.setParamtersDesc("void");
        return request;
    }

    public static boolean isHeartbeatRequest(Object message) {
        if (!(message instanceof Request)) {
            return false;
        }
        if (message instanceof HeartbeatRequest) {
            return true;
        }
        Request request = (Request)message;
        return "com.weibo.api.motan.rpc.heartbeat".equals(request.getInterfaceName()) && "heartbeat".equals(request.getMethodName()) && "void".endsWith(request.getParamtersDesc());
    }

    public static Response getDefaultHeartbeatResponse(long requestId) {
        HeartbeatResponse response = new HeartbeatResponse();
        response.setRequestId(requestId);
        response.setValue("heartbeat");
        return response;
    }

    public static boolean isHeartbeatResponse(Object message) {
        return message instanceof HeartbeatResponse;
    }

    static class HeartbeatRequest
    extends DefaultRequest {
        HeartbeatRequest() {
        }
    }

    static class HeartbeatResponse
    extends DefaultResponse {
        HeartbeatResponse() {
        }
    }

    private static class HeartMessageHandleWrapper
    implements MessageHandler {
        private MessageHandler messageHandler;

        public HeartMessageHandleWrapper(MessageHandler messageHandler) {
            this.messageHandler = messageHandler;
        }

        @Override
        public Object handle(Channel channel, Object message) {
            if (DefaultRpcHeartbeatFactory.isHeartbeatRequest(message)) {
                Response response = DefaultRpcHeartbeatFactory.getDefaultHeartbeatResponse(((Request)message).getRequestId());
                response.setRpcProtocolVersion(((Request)message).getRpcProtocolVersion());
                return response;
            }
            return this.messageHandler.handle(channel, message);
        }

        @Override
        public Map<String, Object> getRuntimeInfo() {
            return this.messageHandler.getRuntimeInfo();
        }
    }
}

