/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.support;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.runtime.GlobalRuntime;
import com.weibo.api.motan.transport.Client;
import com.weibo.api.motan.transport.Endpoint;
import com.weibo.api.motan.transport.EndpointFactory;
import com.weibo.api.motan.transport.EndpointManager;
import com.weibo.api.motan.transport.HeartbeatFactory;
import com.weibo.api.motan.transport.MessageHandler;
import com.weibo.api.motan.transport.Server;
import com.weibo.api.motan.transport.support.HeartbeatClientEndpointManager;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractEndpointFactory
implements EndpointFactory {
    protected final Map<String, Server> ipPort2ServerShareChannel = new HashMap<String, Server>();
    protected ConcurrentMap<Server, Set<String>> server2UrlsShareChannel = new ConcurrentHashMap<Server, Set<String>>();
    private EndpointManager heartbeatClientEndpointManager = new HeartbeatClientEndpointManager();

    public AbstractEndpointFactory() {
        this.heartbeatClientEndpointManager.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Server createServer(URL url, MessageHandler messageHandler) {
        messageHandler = this.getHeartbeatFactory(url).wrapMessageHandler(messageHandler);
        Map<String, Server> map = this.ipPort2ServerShareChannel;
        synchronized (map) {
            String ipPort = url.getServerPortStr();
            String protocolKey = MotanFrameworkUtil.getProtocolKey(url);
            boolean shareChannel = url.getBooleanParameter(URLParamType.shareChannel.getName(), URLParamType.shareChannel.getBooleanValue());
            if (!shareChannel) {
                LoggerUtil.info(this.getClass().getSimpleName() + " create no_share_channel server: url={}", url);
                if (url.getPort() == 0) {
                    url = url.createCopy();
                }
                return this.innerCreateServer(url, messageHandler);
            }
            LoggerUtil.info(this.getClass().getSimpleName() + " create share_channel server: url={}", url);
            Server server = this.ipPort2ServerShareChannel.get(ipPort);
            if (server != null) {
                if (!MotanFrameworkUtil.checkIfCanShareServiceChannel(server.getUrl(), url)) {
                    throw new MotanFrameworkException("Service export Error: share channel but some config param is different, protocol or codec or serialize or maxContentLength or maxServerConnection or maxWorkerThread or heartbeatFactory, source=" + server.getUrl() + " target=" + url, MotanErrorMsgConstant.FRAMEWORK_EXPORT_ERROR);
                }
                this.saveEndpoint2Urls(this.server2UrlsShareChannel, server, protocolKey);
                return server;
            }
            url = url.createCopy();
            url.setPath("");
            server = this.innerCreateServer(url, messageHandler);
            this.ipPort2ServerShareChannel.put(ipPort, server);
            this.saveEndpoint2Urls(this.server2UrlsShareChannel, server, protocolKey);
            GlobalRuntime.addServer(ipPort, server);
            return server;
        }
    }

    @Override
    public Client createClient(URL url) {
        LoggerUtil.info(this.getClass().getSimpleName() + " create client: url={}", url);
        return this.createClient(url, this.heartbeatClientEndpointManager);
    }

    @Override
    public void safeReleaseResource(Server server, URL url) {
        this.safeReleaseResource(server, url, this.ipPort2ServerShareChannel, this.server2UrlsShareChannel);
    }

    @Override
    public void safeReleaseResource(Client client, URL url) {
        this.destroy(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Endpoint> void safeReleaseResource(T endpoint, URL url, Map<String, T> ipPort2Endpoint, ConcurrentMap<T, Set<String>> endpoint2Urls) {
        boolean shareChannel = url.getBooleanParameter(URLParamType.shareChannel.getName(), URLParamType.shareChannel.getBooleanValue());
        if (!shareChannel) {
            this.destroy(endpoint);
            return;
        }
        Map<String, T> map = ipPort2Endpoint;
        synchronized (map) {
            String ipPort = url.getServerPortStr();
            String protocolKey = MotanFrameworkUtil.getProtocolKey(url);
            if (endpoint != ipPort2Endpoint.get(ipPort)) {
                this.destroy(endpoint);
                return;
            }
            Set urls = (Set)endpoint2Urls.get(endpoint);
            urls.remove(protocolKey);
            if (urls.isEmpty()) {
                this.destroy(endpoint);
                ipPort2Endpoint.remove(ipPort);
                endpoint2Urls.remove(endpoint);
            }
        }
    }

    private <T> void saveEndpoint2Urls(ConcurrentMap<T, Set<String>> map, T endpoint, String namespace) {
        Set<String> sets = (HashSet<String>)map.get(endpoint);
        if (sets == null) {
            sets = new HashSet<String>();
            sets.add(namespace);
            map.putIfAbsent(endpoint, sets);
            sets = (Set)map.get(endpoint);
        }
        sets.add(namespace);
    }

    private HeartbeatFactory getHeartbeatFactory(URL url) {
        String heartbeatFactoryName = url.getParameter(URLParamType.heartbeatFactory.getName(), URLParamType.heartbeatFactory.getValue());
        return this.getHeartbeatFactory(heartbeatFactoryName);
    }

    private HeartbeatFactory getHeartbeatFactory(String heartbeatFactoryName) {
        return ExtensionLoader.getExtensionLoader(HeartbeatFactory.class).getExtension(heartbeatFactoryName);
    }

    private Client createClient(URL url, EndpointManager endpointManager) {
        Client client = this.innerCreateClient(url);
        endpointManager.addEndpoint(client);
        return client;
    }

    private <T extends Endpoint> void destroy(T endpoint) {
        if (endpoint instanceof Client) {
            endpoint.close();
            this.heartbeatClientEndpointManager.removeEndpoint(endpoint);
        } else {
            endpoint.close();
            GlobalRuntime.removeServer(endpoint.getUrl().getServerPortStr());
        }
    }

    public Map<String, Server> getShallServerChannels() {
        return Collections.unmodifiableMap(this.ipPort2ServerShareChannel);
    }

    public EndpointManager getEndpointManager() {
        return this.heartbeatClientEndpointManager;
    }

    protected abstract Server innerCreateServer(URL var1, MessageHandler var2);

    protected abstract Client innerCreateClient(URL var1);
}

