/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.DefaultRequest;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.runtime.GlobalRuntime;
import com.weibo.api.motan.runtime.meta.MetaService;
import com.weibo.api.motan.serialize.DeserializableObject;
import com.weibo.api.motan.util.MotanGlobalConfigUtil;
import com.weibo.api.motan.util.RequestIdGenerator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class MetaUtil {
    public static final String defaultEnvMetaPrefix = "META_";
    public static final String ENV_META_PREFIX = MotanGlobalConfigUtil.getConfig("envMetaPrefix", "META_");
    public static final String SERVICE_NAME = MetaService.class.getName();
    public static final String METHOD_NAME = "getDynamicMeta";
    private static final Class<?> RETURN_TYPE = Map.class;
    private static int cacheExpireSecond = 3;
    private static final int notSupportExpireSecond = 30;
    private static final Cache<String, Map<String, String>> metaCache;
    private static final Cache<String, Boolean> notSupportCache;
    private static final Set<String> notSupportSerializer;

    public static HashMap<String, String> _getOriginMetaInfoFromEnv() {
        HashMap<String, String> metas = new HashMap<String, String>();
        for (String key : System.getenv().keySet()) {
            if (!key.startsWith(ENV_META_PREFIX)) continue;
            metas.put(key, System.getenv(key));
        }
        return metas;
    }

    public static Map<String, String> getLocalMeta() {
        return GlobalRuntime.getMergedMeta();
    }

    public static Map<String, String> getRefererDynamicMeta(Referer<?> referer) throws ExecutionException {
        return (Map)metaCache.get((Object)MetaUtil.getCacheKey(referer.getUrl()), () -> MetaUtil.getRemoteDynamicMeta(referer));
    }

    private static Map<String, String> getRemoteDynamicMeta(Referer<?> referer) throws MotanServiceException, IOException {
        String key = MetaUtil.getCacheKey(referer.getUrl());
        if (notSupportCache.getIfPresent((Object)key) != null || !MetaUtil.isSupport(referer.getUrl())) {
            throw new MotanServiceException(MotanErrorMsgConstant.SERVICE_NOT_SUPPORT_ERROR);
        }
        if (!referer.isAvailable()) {
            throw new MotanServiceException("referer unavailable");
        }
        try {
            Object value = referer.call(MetaUtil.buildMetaServiceRequest()).getValue();
            if (value instanceof DeserializableObject) {
                value = ((DeserializableObject)value).deserialize(RETURN_TYPE);
            }
            return (Map)value;
        }
        catch (Exception e) {
            MotanServiceException mse;
            if (e instanceof MotanServiceException && ((mse = (MotanServiceException)e).getStatus() == MotanErrorMsgConstant.SERVICE_NOT_SUPPORT_ERROR.getStatus() || mse.getOriginMessage().contains("provider"))) {
                notSupportCache.put((Object)key, (Object)Boolean.TRUE);
                throw new MotanServiceException(MotanErrorMsgConstant.SERVICE_NOT_SUPPORT_ERROR);
            }
            throw e;
        }
    }

    private static boolean isSupport(URL url) {
        if (url.getBooleanParameter(URLParamType.dynamicMeta.getName(), URLParamType.dynamicMeta.getBooleanValue()).booleanValue() && !notSupportSerializer.contains(url.getParameter(URLParamType.serialize.getName(), "")) && ("motan".equals(url.getProtocol()) || "motan2".equals(url.getProtocol()))) {
            return true;
        }
        notSupportCache.put((Object)MetaUtil.getCacheKey(url), (Object)true);
        return false;
    }

    private static String getCacheKey(URL url) {
        return url.getHost() + ":" + url.getPort();
    }

    public static Map<String, String> getRefererStaticMeta(Referer<?> referer) {
        HashMap<String, String> meta = new HashMap<String, String>();
        referer.getUrl().getParameters().forEach((k, v) -> {
            if (k.startsWith(defaultEnvMetaPrefix) || k.startsWith(ENV_META_PREFIX)) {
                meta.put((String)k, (String)v);
            }
        });
        return meta;
    }

    public static Request buildMetaServiceRequest() {
        DefaultRequest request = new DefaultRequest();
        request.setRequestId(RequestIdGenerator.getRequestId());
        request.setInterfaceName(SERVICE_NAME);
        request.setMethodName(METHOD_NAME);
        request.setAttachment("M_fws", "y");
        return request;
    }

    public static String getMetaValue(Map<String, String> meta, String keySuffix) {
        String value = null;
        if (meta != null && (value = meta.get(ENV_META_PREFIX + keySuffix)) == null) {
            value = meta.get(defaultEnvMetaPrefix + keySuffix);
        }
        return value;
    }

    public static void addStaticMeta(URL url) {
        if (url != null) {
            url.getParameters().putAll(GlobalRuntime.getEnvMeta());
        }
    }

    public static void clearCache() {
        metaCache.invalidateAll();
        notSupportCache.invalidateAll();
    }

    static {
        notSupportSerializer = Sets.newHashSet((Object[])new String[]{"protobuf", "grpc-pb", "grpc-pb-json"});
        String expireSecond = MotanGlobalConfigUtil.getConfig("metaCacheExpireSecond");
        if (StringUtils.isNotBlank((CharSequence)expireSecond)) {
            try {
                int tempCacheExpireSecond = Integer.parseInt(expireSecond);
                if (tempCacheExpireSecond > 0) {
                    cacheExpireSecond = tempCacheExpireSecond;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        metaCache = CacheBuilder.newBuilder().expireAfterWrite((long)cacheExpireSecond, TimeUnit.SECONDS).build();
        notSupportCache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    }
}

