/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc;

import com.weibo.api.motan.exception.MotanBizException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.protocol.rpc.RpcProtocolVersion;
import com.weibo.api.motan.rpc.Callbackable;
import com.weibo.api.motan.rpc.DefaultCallbackHolder;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.ResponseFuture;
import com.weibo.api.motan.rpc.Traceable;
import com.weibo.api.motan.rpc.TraceableContext;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class DefaultResponse
implements Response,
Traceable,
Callbackable,
Serializable {
    private static final long serialVersionUID = 4281186647291615871L;
    private Object value;
    private Exception exception;
    private long requestId;
    private long processTime;
    private int timeout;
    private Map<String, String> attachments;
    private byte rpcProtocolVersion = RpcProtocolVersion.VERSION_1.getVersion();
    private int serializeNumber = 0;
    private TraceableContext traceableContext = new TraceableContext();
    private Callbackable callbackHolder = new DefaultCallbackHolder();

    public DefaultResponse() {
    }

    public DefaultResponse(long requestId) {
        this.requestId = requestId;
    }

    public DefaultResponse(Response response) {
        this.value = response.getValue();
        this.exception = response.getException();
        this.requestId = response.getRequestId();
        this.processTime = response.getProcessTime();
        this.timeout = response.getTimeout();
        this.rpcProtocolVersion = response.getRpcProtocolVersion();
        this.serializeNumber = response.getSerializeNumber();
        this.attachments = response.getAttachments();
        this.updateTraceableContextFromResponse(response);
    }

    public DefaultResponse(Object value) {
        this.value = value;
    }

    public DefaultResponse(Object value, long requestId) {
        this.value = value;
        this.requestId = requestId;
    }

    public static DefaultResponse fromServerEndResponseFuture(ResponseFuture responseFuture) {
        DefaultResponse response = new DefaultResponse();
        if (responseFuture.getException() != null) {
            response.setException(new MotanBizException("provider call process error", responseFuture.getException()));
        } else {
            response.setValue(responseFuture.getValue());
        }
        response.updateTraceableContextFromResponse(responseFuture);
        response.updateCallbackHolderFromResponse(responseFuture);
        if (!responseFuture.getAttachments().isEmpty()) {
            response.attachments = responseFuture.getAttachments();
        }
        return response;
    }

    @Override
    public Object getValue() {
        if (this.exception != null) {
            throw this.exception instanceof RuntimeException ? (RuntimeException)this.exception : new MotanServiceException(this.exception.getMessage(), this.exception);
        }
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(long requestId) {
        this.requestId = requestId;
    }

    @Override
    public long getProcessTime() {
        return this.processTime;
    }

    @Override
    public void setProcessTime(long time) {
        this.processTime = time;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public Map<String, String> getAttachments() {
        return this.attachments != null ? this.attachments : Collections.emptyMap();
    }

    public void setAttachments(Map<String, String> attachments) {
        this.attachments = attachments;
    }

    @Override
    public void setAttachment(String key, String value) {
        if (this.attachments == null) {
            this.attachments = new HashMap<String, String>();
        }
        this.attachments.put(key, value);
    }

    @Override
    public byte getRpcProtocolVersion() {
        return this.rpcProtocolVersion;
    }

    @Override
    public void setRpcProtocolVersion(byte rpcProtocolVersion) {
        this.rpcProtocolVersion = rpcProtocolVersion;
    }

    @Override
    public void setSerializeNumber(int number) {
        this.serializeNumber = number;
    }

    @Override
    public int getSerializeNumber() {
        return this.serializeNumber;
    }

    @Override
    public void addFinishCallback(Runnable runnable, Executor executor) {
        this.callbackHolder.addFinishCallback(runnable, executor);
    }

    @Override
    public void onFinish() {
        this.callbackHolder.onFinish();
    }

    @Override
    public TraceableContext getTraceableContext() {
        return this.traceableContext;
    }

    @Override
    public Callbackable getCallbackHolder() {
        return this.callbackHolder;
    }

    private void updateTraceableContextFromResponse(Response response) {
        TraceableContext tempTraceableContext;
        if (response instanceof Traceable && (tempTraceableContext = ((Traceable)((Object)response)).getTraceableContext()) != null) {
            this.traceableContext = tempTraceableContext;
        }
    }

    private void updateCallbackHolderFromResponse(Response response) {
        Callbackable holder;
        if (response instanceof Callbackable && (holder = ((Callbackable)((Object)response)).getCallbackHolder()) != null) {
            this.callbackHolder = holder;
        }
    }
}

