/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.rpc;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.AbstractReferer;
import com.weibo.api.motan.rpc.Future;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.Client;
import com.weibo.api.motan.transport.EndpointFactory;
import com.weibo.api.motan.transport.TransportException;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.Map;

public class DefaultRpcReferer<T>
extends AbstractReferer<T> {
    protected Client client;
    protected EndpointFactory endpointFactory;

    public DefaultRpcReferer(Class<T> clz, URL url, URL serviceUrl) {
        super(clz, url, serviceUrl);
        this.endpointFactory = ExtensionLoader.getExtensionLoader(EndpointFactory.class).getExtension(url.getParameter(URLParamType.endpointFactory.getName(), URLParamType.endpointFactory.getValue()));
        this.client = this.endpointFactory.createClient(url);
    }

    @Override
    protected Response doCall(Request request) {
        try {
            request.setAttachment(URLParamType.group.getName(), this.serviceUrl.getGroup());
            return this.client.request(request);
        }
        catch (TransportException exception) {
            throw new MotanServiceException("DefaultRpcReferer call Error: url=" + this.url.getUri(), exception);
        }
    }

    @Override
    protected void decrActiveCount(Request request, Response response) {
        if (!(response instanceof Future)) {
            this.activeRefererCount.decrementAndGet();
            return;
        }
        Future future = (Future)((Object)response);
        future.addListener(future1 -> this.activeRefererCount.decrementAndGet());
    }

    @Override
    protected boolean doInit() {
        return this.client.open();
    }

    @Override
    public boolean isAvailable() {
        return this.client.isAvailable();
    }

    @Override
    public void destroy() {
        this.endpointFactory.safeReleaseResource(this.client, this.url);
        LoggerUtil.info("DefaultRpcReferer destroy client: url={}" + this.url);
    }

    @Override
    public Map<String, Object> getRuntimeInfo() {
        Map<String, Object> infos = super.getRuntimeInfo();
        infos.putAll(this.client.getRuntimeInfo());
        return infos;
    }
}

