/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.config.AbstractConfig;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.runtime.GlobalRuntime;
import com.weibo.api.motan.transport.DefaultMeshClient;
import com.weibo.api.motan.transport.MeshClient;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class MeshClientConfig
extends AbstractConfig {
    protected Integer port;
    protected Integer mport;
    protected String host;
    protected String application;
    protected Integer minClientConnection;
    protected Integer maxClientConnection;
    protected String serialization;
    protected Integer connectTimeout;
    protected Integer requestTimeout;
    protected Integer maxContentLength;
    protected String filter;
    protected String accessLog;
    protected Integer mingzSize;
    protected String endpointFactory;
    protected String codec;
    protected String check;
    protected Boolean asyncInitConnection;
    protected Integer fusingThreshold;
    protected MeshClient meshClient;
    protected URL url;
    protected AtomicBoolean initialized = new AtomicBoolean(false);

    public MeshClient getMeshClient() {
        if (this.meshClient == null) {
            this.initMeshClient();
        }
        return this.meshClient;
    }

    protected synchronized void initMeshClient() {
        DefaultMeshClient defaultMeshClient;
        block3: {
            if (this.initialized.get()) {
                return;
            }
            this.buildMeshClientUrl();
            defaultMeshClient = new DefaultMeshClient(this.url);
            try {
                defaultMeshClient.init();
            }
            catch (Exception e) {
                LoggerUtil.error("mesh client init fail. url:" + this.url.toFullStr(), e);
                boolean check = Boolean.parseBoolean(this.url.getParameter(URLParamType.check.getName(), URLParamType.check.getValue()));
                if (!check) break block3;
                throw e;
            }
        }
        this.meshClient = defaultMeshClient;
        GlobalRuntime.addMeshClient(this.meshClient.getUrl().getIdentity(), this.meshClient);
        this.initialized.set(true);
    }

    protected synchronized void destroy() throws Exception {
        if (this.meshClient != null) {
            GlobalRuntime.removeMeshClient(this.meshClient.getUrl().getIdentity());
            this.meshClient.destroy();
            this.meshClient = null;
        }
        this.initialized.set(false);
    }

    private void buildMeshClientUrl() {
        Map<String, String> params = DefaultMeshClient.getDefaultParams();
        this.appendConfigParams(params);
        this.url = new URL(params.get(URLParamType.protocol.getName()), this.host == null ? "localhost" : this.host, this.port == null ? 9981 : this.port, MeshClient.class.getName(), params);
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getMport() {
        return this.mport;
    }

    public void setMport(Integer mport) {
        this.mport = mport;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public Integer getMinClientConnection() {
        return this.minClientConnection;
    }

    public void setMinClientConnection(Integer minClientConnection) {
        this.minClientConnection = minClientConnection;
    }

    public Integer getMaxClientConnection() {
        return this.maxClientConnection;
    }

    public void setMaxClientConnection(Integer maxClientConnection) {
        this.maxClientConnection = maxClientConnection;
    }

    public String getSerialization() {
        return this.serialization;
    }

    public void setSerialization(String serialization) {
        this.serialization = serialization;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public Integer getMaxContentLength() {
        return this.maxContentLength;
    }

    public void setMaxContentLength(Integer maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getAccessLog() {
        return this.accessLog;
    }

    public void setAccessLog(String accessLog) {
        this.accessLog = accessLog;
    }

    public Integer getMingzSize() {
        return this.mingzSize;
    }

    public void setMingzSize(Integer mingzSize) {
        this.mingzSize = mingzSize;
    }

    public String getEndpointFactory() {
        return this.endpointFactory;
    }

    public void setEndpointFactory(String endpointFactory) {
        this.endpointFactory = endpointFactory;
    }

    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public String getCheck() {
        return this.check;
    }

    public void setCheck(String check) {
        this.check = check;
    }

    public Boolean getAsyncInitConnection() {
        return this.asyncInitConnection;
    }

    public void setAsyncInitConnection(Boolean asyncInitConnection) {
        this.asyncInitConnection = asyncInitConnection;
    }

    public Integer getFusingThreshold() {
        return this.fusingThreshold;
    }

    public void setFusingThreshold(Integer fusingThreshold) {
        this.fusingThreshold = fusingThreshold;
    }
}

