/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.cluster.loadbalance;

import com.weibo.api.motan.cluster.loadbalance.AbstractLoadBalance;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.util.MathUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

@SpiMeta(name="roundrobin")
public class RoundRobinLoadBalance<T>
extends AbstractLoadBalance<T> {
    private final AtomicInteger idx = new AtomicInteger(0);

    @Override
    protected Referer<T> doSelect(Request request) {
        List referers = this.getReferers();
        Referer ref = referers.get(this.getNextNonNegative() % referers.size());
        if (ref.isAvailable()) {
            return ref;
        }
        return this.selectFromRandomStart(referers);
    }

    @Override
    protected void doSelectToHolder(Request request, List<Referer<T>> refersHolder) {
        this.addToSelectHolderFromStart(this.getReferers(), refersHolder, this.getNextNonNegative());
    }

    private int getNextNonNegative() {
        return MathUtil.getNonNegative(this.idx.incrementAndGet());
    }

    @Override
    public boolean canSelectMulti() {
        return false;
    }
}

