/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc;

import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.ReflectUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractProvider<T>
implements Provider<T> {
    protected Class<T> clz;
    protected URL url;
    protected boolean alive = false;
    protected boolean close = false;
    protected Map<String, Method> methodMap = new HashMap<String, Method>();

    public AbstractProvider(URL url, Class<T> clz) {
        this.url = url;
        this.clz = clz;
        this.initMethodMap(clz);
    }

    @Override
    public Response call(Request request) {
        Response response = this.invoke(request);
        return response;
    }

    protected abstract Response invoke(Request var1);

    @Override
    public void init() {
        this.alive = true;
    }

    @Override
    public void destroy() {
        this.alive = false;
        this.close = true;
    }

    @Override
    public boolean isAvailable() {
        return this.alive;
    }

    @Override
    public String desc() {
        if (this.url != null) {
            return this.url.toString();
        }
        return null;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public Class<T> getInterface() {
        return this.clz;
    }

    @Override
    public Method lookupMethod(String methodName, String methodDesc) {
        Method method = null;
        String fullMethodName = ReflectUtil.getMethodDesc(methodName, methodDesc);
        method = this.methodMap.get(fullMethodName);
        if (method == null && StringUtils.isBlank((CharSequence)methodDesc) && (method = this.methodMap.get(methodName)) == null) {
            method = this.methodMap.get(methodName.substring(0, 1).toLowerCase() + methodName.substring(1));
        }
        return method;
    }

    private void initMethodMap(Class<T> clz) {
        Method[] methods = clz.getMethods();
        ArrayList<String> dupList = new ArrayList<String>();
        for (Method method : methods) {
            String methodDesc = ReflectUtil.getMethodDesc(method);
            this.methodMap.put(methodDesc, method);
            if (this.methodMap.get(method.getName()) == null) {
                this.methodMap.put(method.getName(), method);
                continue;
            }
            dupList.add(method.getName());
        }
        if (!dupList.isEmpty()) {
            for (String removedName : dupList) {
                this.methodMap.remove(removedName);
            }
        }
    }
}

