/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.filter;

import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.rpc.Application;
import com.weibo.api.motan.rpc.ApplicationInfo;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.util.ExceptionUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import com.weibo.api.motan.util.StatsUtil;

@SpiMeta(name="statistic")
public class AccessStatisticFilter
implements Filter {
    protected static Application RPC_SERVICES = new Application("statisitic", "rpc_service");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response filter(Caller<?> caller, Request request) {
        long start = System.currentTimeMillis();
        StatsUtil.AccessStatus accessStatus = StatsUtil.AccessStatus.NORMAL;
        boolean specialException = true;
        long bizProcessTime = 0L;
        try {
            Response response = caller.call(request);
            if (response == null) {
                accessStatus = StatsUtil.AccessStatus.OTHER_EXCEPTION;
            } else {
                if (response.getException() != null) {
                    accessStatus = ExceptionUtil.isBizException(response.getException()) ? StatsUtil.AccessStatus.BIZ_EXCEPTION : StatsUtil.AccessStatus.OTHER_EXCEPTION;
                }
                specialException = false;
                bizProcessTime = response.getProcessTime();
            }
            Response response2 = response;
            return response2;
        }
        finally {
            Application application;
            long end = System.currentTimeMillis();
            if (specialException) {
                accessStatus = StatsUtil.AccessStatus.OTHER_EXCEPTION;
                bizProcessTime = end - start;
            }
            String statName = caller.getUrl().getProtocol() + "://" + MotanFrameworkUtil.getGroupMethodString(request);
            if (caller instanceof Provider) {
                application = RPC_SERVICES;
                StatsUtil.accessStatistic(statName, application, end, end - start, bizProcessTime, accessStatus);
            }
            application = ApplicationInfo.getApplication(caller.getUrl());
            StatsUtil.accessStatistic(statName, application, end, end - start, bizProcessTime, accessStatus);
        }
    }
}

