/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MotanDigestUtil {
    private static Logger log = LoggerFactory.getLogger(MotanDigestUtil.class);
    private static ThreadLocal<CRC32> crc32Provider = new ThreadLocal<CRC32>(){

        @Override
        protected CRC32 initialValue() {
            return new CRC32();
        }
    };

    public static long getCrc32(String str) {
        try {
            return MotanDigestUtil.getCrc32(str.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.warn(String.format("Error: getCrc32, str=%s", str), (Throwable)e);
            return -1L;
        }
    }

    public static long getCrc32(byte[] b) {
        CRC32 crc = crc32Provider.get();
        crc.reset();
        crc.update(b);
        return crc.getValue();
    }

    public static String md5LowerCase(String plainText) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(plainText.getBytes());
            byte[] b = md.digest();
            StringBuilder buf = new StringBuilder("");
            for (int n : b) {
                int i = n;
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            return buf.toString();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("md5 digest error!", (Throwable)e);
            return null;
        }
    }
}

