/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc;

import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class RefererSupports {
    private static ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(10);
    private static final int DELAY_TIME = 1000;

    public static <T> void delayDestroy(final List<Referer<T>> referers) {
        if (referers == null || referers.isEmpty()) {
            return;
        }
        scheduledExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                for (Referer referer : referers) {
                    try {
                        referer.destroy();
                    }
                    catch (Exception e) {
                        LoggerUtil.error("RefererSupports delayDestroy Error: url=" + referer.getUrl().getUri(), e);
                    }
                }
            }
        }, 1000L, TimeUnit.MILLISECONDS);
        LoggerUtil.info("RefererSupports delayDestroy Success: size={} service={} urls={}", referers.size(), referers.get(0).getUrl().getIdentity(), RefererSupports.getServerPorts(referers));
    }

    private static <T> String getServerPorts(List<Referer<T>> referers) {
        if (referers == null || referers.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (Referer<T> referer : referers) {
            builder.append(referer.getUrl().getServerPortStr()).append(",");
        }
        builder.setLength(builder.length() - 1);
        builder.append("]");
        return builder.toString();
    }
}

