/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.proxy;

import com.weibo.api.motan.cluster.Cluster;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.ApplicationInfo;
import com.weibo.api.motan.rpc.DefaultRequest;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.switcher.Switcher;
import com.weibo.api.motan.switcher.SwitcherService;
import com.weibo.api.motan.util.ExceptionUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import com.weibo.api.motan.util.ReflectUtil;
import com.weibo.api.motan.util.RequestIdGenerator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RefererInvocationHandler<T>
implements InvocationHandler {
    private List<Cluster<T>> clusters;
    private Class<T> clz;
    private SwitcherService switcherService = null;

    public RefererInvocationHandler(Class<T> clz, Cluster<T> cluster) {
        this.clz = clz;
        this.clusters = new ArrayList<Cluster<T>>(1);
        this.clusters.add(cluster);
        this.init();
    }

    public RefererInvocationHandler(Class<T> clz, List<Cluster<T>> clusters) {
        this.clz = clz;
        this.clusters = clusters;
        this.init();
    }

    private void init() {
        String switchName = this.clusters.get(0).getUrl().getParameter(URLParamType.switcherService.getName(), URLParamType.switcherService.getValue());
        this.switcherService = ExtensionLoader.getExtensionLoader(SwitcherService.class).getExtension(switchName);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isLocalMethod(method)) {
            if ("toString".equals(method.getName())) {
                return this.clustersToString();
            }
            throw new MotanServiceException("can not invoke local method:" + method.getName());
        }
        DefaultRequest request = new DefaultRequest();
        request.setRequestId(RequestIdGenerator.getRequestId());
        request.setArguments(args);
        request.setMethodName(method.getName());
        request.setParamtersDesc(ReflectUtil.getMethodParamDesc(method));
        request.setInterfaceName(this.clz.getName());
        request.setAttachment(URLParamType.requestIdFromClient.getName(), String.valueOf(RequestIdGenerator.getRequestIdFromClient()));
        for (Cluster<T> cluster : this.clusters) {
            String protocolSwitcher = "protocol:" + cluster.getUrl().getProtocol();
            Switcher switcher = this.switcherService.getSwitcher(protocolSwitcher);
            if (switcher != null && !switcher.isOn()) continue;
            request.setAttachment(URLParamType.version.getName(), cluster.getUrl().getVersion());
            request.setAttachment(URLParamType.clientGroup.getName(), cluster.getUrl().getGroup());
            request.setAttachment(URLParamType.application.getName(), ApplicationInfo.getApplication(cluster.getUrl()).getApplication());
            request.setAttachment(URLParamType.module.getName(), ApplicationInfo.getApplication(cluster.getUrl()).getModule());
            Response response = null;
            boolean throwException = Boolean.parseBoolean(cluster.getUrl().getParameter(URLParamType.throwException.getName(), URLParamType.throwException.getValue()));
            try {
                response = cluster.call(request);
                return response.getValue();
            }
            catch (RuntimeException e) {
                if (ExceptionUtil.isBizException(e)) {
                    Throwable t = e.getCause();
                    if (t != null && t instanceof Exception) {
                        throw t;
                    }
                    String msg = t == null ? "biz exception cause is null" : "biz exception cause is throwable error:" + t.getClass() + ", errmsg:" + t.getMessage();
                    throw new MotanServiceException(msg, MotanErrorMsgConstant.SERVICE_DEFAULT_ERROR);
                }
                if (!throwException) {
                    LoggerUtil.warn("RefererInvocationHandler invoke false, so return default value: uri=" + cluster.getUrl().getUri() + " " + MotanFrameworkUtil.toString(request), e);
                    return this.getDefaultReturnValue(method.getReturnType());
                }
                LoggerUtil.error("RefererInvocationHandler invoke Error: uri=" + cluster.getUrl().getUri() + " " + MotanFrameworkUtil.toString(request), e);
                throw e;
            }
        }
        throw new MotanServiceException("Referer call Error: cluster not exist, interface=" + this.clz.getName() + " " + MotanFrameworkUtil.toString(request), MotanErrorMsgConstant.SERVICE_UNFOUND);
    }

    public boolean isLocalMethod(Method method) {
        if (method.getDeclaringClass().equals(Object.class)) {
            try {
                Method interfaceMethod = this.clz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                return false;
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    private String clustersToString() {
        StringBuilder sb = new StringBuilder();
        for (Cluster<T> cluster : this.clusters) {
            sb.append("{protocol:").append(cluster.getUrl().getProtocol());
            for (Referer<T> refer : cluster.getReferers()) {
                sb.append("[").append(refer.getUrl().toSimpleString()).append(", available:").append(refer.isAvailable()).append("]");
            }
            sb.append("}");
        }
        return sb.toString();
    }

    private Object getDefaultReturnValue(Class<?> returnType) {
        if (returnType != null && returnType.isPrimitive()) {
            return PrimitiveDefault.getDefaultReturnValue(returnType);
        }
        return null;
    }

    private static class PrimitiveDefault {
        private static boolean defaultBoolean;
        private static char defaultChar;
        private static byte defaultByte;
        private static short defaultShort;
        private static int defaultInt;
        private static long defaultLong;
        private static float defaultFloat;
        private static double defaultDouble;
        private static Map<Class<?>, Object> primitiveValues;

        private PrimitiveDefault() {
        }

        public static Object getDefaultReturnValue(Class<?> returnType) {
            return primitiveValues.get(returnType);
        }

        static {
            primitiveValues = new HashMap();
            primitiveValues.put(Boolean.TYPE, defaultBoolean);
            primitiveValues.put(Character.TYPE, Character.valueOf(defaultChar));
            primitiveValues.put(Byte.TYPE, defaultByte);
            primitiveValues.put(Short.TYPE, defaultShort);
            primitiveValues.put(Integer.TYPE, defaultInt);
            primitiveValues.put(Long.TYPE, defaultLong);
            primitiveValues.put(Float.TYPE, Float.valueOf(defaultFloat));
            primitiveValues.put(Double.TYPE, defaultDouble);
        }
    }
}

