/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.cluster.loadbalance;

import com.weibo.api.motan.cluster.loadbalance.AbstractLoadBalance;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.util.MathUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

@SpiMeta(name="roundrobin")
public class RoundRobinLoadBalance<T>
extends AbstractLoadBalance<T> {
    private AtomicInteger idx = new AtomicInteger(0);

    @Override
    protected Referer<T> doSelect(Request request) {
        List referers = this.getReferers();
        int index = this.getNextPositive();
        for (int i = 0; i < referers.size(); ++i) {
            Referer ref = referers.get((i + index) % referers.size());
            if (!ref.isAvailable()) continue;
            return ref;
        }
        return null;
    }

    @Override
    protected void doSelectToHolder(Request request, List<Referer<T>> refersHolder) {
        List referers = this.getReferers();
        int index = this.getNextPositive();
        int count = 0;
        for (int i = 0; i < referers.size() && count < 10; ++i) {
            Referer referer = referers.get((i + index) % referers.size());
            if (!referer.isAvailable()) continue;
            refersHolder.add(referer);
            ++count;
        }
    }

    private int getNextPositive() {
        return MathUtil.getPositive(this.idx.incrementAndGet());
    }
}

