/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.cluster.loadbalance;

import com.weibo.api.motan.cluster.loadbalance.AbstractLoadBalance;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

@SpiMeta(name="activeWeight")
public class ActiveWeightLoadBalance<T>
extends AbstractLoadBalance<T> {
    public static final int MAX_REFERER_COUNT = 10;
    private static Random random = new Random();

    @Override
    protected Referer<T> doSelect(Request request) {
        List referers = this.getReferers();
        int refererSize = referers.size();
        int startIndex = random.nextInt(refererSize);
        int currentAvailableCursor = 0;
        Referer referer = null;
        for (int currentCursor = 0; currentAvailableCursor < 10 && currentCursor < refererSize; ++currentCursor) {
            Referer temp = referers.get((startIndex + currentCursor) % refererSize);
            if (!temp.isAvailable()) continue;
            ++currentAvailableCursor;
            if (referer != null) continue;
            referer = temp;
        }
        return referer;
    }

    @Override
    protected void doSelectToHolder(Request request, List<Referer<T>> refersHolder) {
        List referers = this.getReferers();
        int refererSize = referers.size();
        int startIndex = random.nextInt(refererSize);
        int currentAvailableCursor = 0;
        for (int currentCursor = 0; currentAvailableCursor < 10 && currentCursor < refererSize; ++currentCursor) {
            Referer temp = referers.get((startIndex + currentCursor) % refererSize);
            if (!temp.isAvailable()) continue;
            ++currentAvailableCursor;
            refersHolder.add(temp);
        }
        Collections.sort(refersHolder, new LowActivePriorityComparator());
    }

    private int compare(Referer<T> referer1, Referer<T> referer2) {
        return referer1.activeRefererCount() - referer2.activeRefererCount();
    }

    static class LowActivePriorityComparator<T>
    implements Comparator<Referer<T>> {
        LowActivePriorityComparator() {
        }

        @Override
        public int compare(Referer<T> referer1, Referer<T> referer2) {
            return referer1.activeRefererCount() - referer2.activeRefererCount();
        }
    }
}

