/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.injvm;

import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.protocol.AbstractProtocol;
import com.weibo.api.motan.rpc.AbstractExporter;
import com.weibo.api.motan.rpc.AbstractReferer;
import com.weibo.api.motan.rpc.Exporter;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;

@SpiMeta(name="injvm")
public class InjvmProtocol
extends AbstractProtocol {
    @Override
    protected <T> Exporter<T> createExporter(Provider<T> provider, URL url) {
        return new InJvmExporter<T>(provider, url);
    }

    @Override
    protected <T> Referer<T> createReferer(Class<T> clz, URL url, URL serviceUrl) {
        return new InjvmReferer<T>(clz, url, serviceUrl);
    }

    class InjvmReferer<T>
    extends AbstractReferer<T> {
        private Exporter<T> exporter;

        public InjvmReferer(Class<T> clz, URL url, URL serviceUrl) {
            super(clz, url, serviceUrl);
        }

        @Override
        protected Response doCall(Request request) {
            if (this.exporter == null) {
                throw new MotanServiceException("InjvmReferer call Error: provider not exist, url=" + this.url.getUri(), MotanErrorMsgConstant.SERVICE_UNFOUND);
            }
            return this.exporter.getProvider().call(request);
        }

        @Override
        protected boolean doInit() {
            String protocolKey = MotanFrameworkUtil.getProtocolKey(this.url);
            this.exporter = (Exporter)InjvmProtocol.this.exporterMap.get(protocolKey);
            if (this.exporter == null) {
                LoggerUtil.error("InjvmReferer init Error: provider not exist, url=" + this.url);
                return false;
            }
            return true;
        }

        @Override
        public void destroy() {
        }
    }

    class InJvmExporter<T>
    extends AbstractExporter<T> {
        public InJvmExporter(Provider<T> provider, URL url) {
            super(provider, url);
        }

        @Override
        public void unexport() {
            String protocolKey = MotanFrameworkUtil.getProtocolKey(this.url);
            Exporter exporter = (Exporter)InjvmProtocol.this.exporterMap.remove(protocolKey);
            if (exporter != null) {
                exporter.destroy();
            }
            LoggerUtil.info("InJvmExporter unexport Success: url=" + this.url);
        }

        @Override
        protected boolean doInit() {
            return true;
        }

        @Override
        public void destroy() {
        }
    }
}

