/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.cluster.loadbalance;

import com.weibo.api.motan.cluster.loadbalance.AbstractLoadBalance;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.NetUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

@SpiMeta(name="localFirst")
public class LocalFirstLoadBalance<T>
extends AbstractLoadBalance<T> {
    public static final int MAX_REFERER_COUNT = 10;
    private static Random random = new Random();

    public static long ipToLong(String addr) {
        String[] addressBytes = addr.split("\\.");
        int length = addressBytes.length;
        if (length < 3) {
            return 0L;
        }
        long ip = 0L;
        try {
            for (int i = 0; i < 4; ++i) {
                ip <<= 8;
                ip |= (long)Integer.parseInt(addressBytes[i]);
            }
        }
        catch (Exception e) {
            LoggerUtil.warn("Warn ipToInt addr is wrong: addr=" + addr);
        }
        return ip;
    }

    @Override
    protected Referer<T> doSelect(Request request) {
        List referers = this.getReferers();
        List localReferers = this.searchLocalReferer(referers, NetUtils.getLocalAddress().getHostAddress());
        if (localReferers.isEmpty()) {
            referers = localReferers;
        }
        int refererSize = referers.size();
        Referer referer = null;
        for (int i = 0; i < refererSize; ++i) {
            Referer temp = referers.get(i % refererSize);
            if (!temp.isAvailable()) continue;
            if (referer == null) {
                referer = temp;
                continue;
            }
            if (this.compare(referer, temp) <= 0) continue;
            referer = temp;
        }
        return referer;
    }

    @Override
    protected void doSelectToHolder(Request request, List<Referer<T>> refersHolder) {
        List referers = this.getReferers();
        List localReferers = this.searchLocalReferer(referers, NetUtils.getLocalAddress().getHostAddress());
        if (!localReferers.isEmpty()) {
            Collections.sort(localReferers, new LowActivePriorityComparator());
            refersHolder.addAll(localReferers);
        }
        int refererSize = referers.size();
        int startIndex = random.nextInt(refererSize);
        int currentAvailableCursor = 0;
        ArrayList remoteReferers = new ArrayList();
        for (int currentCursor = 0; currentAvailableCursor < 10 && currentCursor < refererSize; ++currentCursor) {
            Referer temp = referers.get((startIndex + currentCursor) % refererSize);
            if (!temp.isAvailable() || localReferers.contains(temp)) continue;
            ++currentAvailableCursor;
            remoteReferers.add(temp);
        }
        Collections.sort(remoteReferers, new LowActivePriorityComparator());
        refersHolder.addAll(remoteReferers);
    }

    private List<Referer<T>> searchLocalReferer(List<Referer<T>> referers, String localhost) {
        ArrayList<Referer<T>> localReferers = new ArrayList<Referer<T>>();
        long local = LocalFirstLoadBalance.ipToLong(localhost);
        for (Referer<T> referer : referers) {
            long tmp = LocalFirstLoadBalance.ipToLong(referer.getUrl().getHost());
            if (local == 0L || local != tmp || !referer.isAvailable()) continue;
            localReferers.add(referer);
        }
        return localReferers;
    }

    private int compare(Referer<T> referer1, Referer<T> referer2) {
        return referer1.activeRefererCount() - referer2.activeRefererCount();
    }

    static class LowActivePriorityComparator<T>
    implements Comparator<Referer<T>> {
        LowActivePriorityComparator() {
        }

        @Override
        public int compare(Referer<T> referer1, Referer<T> referer2) {
            return referer1.activeRefererCount() - referer2.activeRefererCount();
        }
    }
}

