/*
 * Decompiled with CFR 0.152.
 */
package com.weedow.schemaorg.serializer.spec;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.weedow.schemaorg.commons.model.JsonLdDataType;
import com.weedow.schemaorg.commons.model.SchemaDataType;
import com.weedow.schemaorg.serializer.converter.Converter;
import com.weedow.schemaorg.serializer.converter.impl.BooleanConverter;
import com.weedow.schemaorg.serializer.converter.impl.CssSelectorTypeConverter;
import com.weedow.schemaorg.serializer.converter.impl.DateConverter;
import com.weedow.schemaorg.serializer.converter.impl.DateTimeConverter;
import com.weedow.schemaorg.serializer.converter.impl.FloatConverter;
import com.weedow.schemaorg.serializer.converter.impl.IntegerConverter;
import com.weedow.schemaorg.serializer.converter.impl.NumberConverter;
import com.weedow.schemaorg.serializer.converter.impl.PronounceableTextConverter;
import com.weedow.schemaorg.serializer.converter.impl.TextConverter;
import com.weedow.schemaorg.serializer.converter.impl.TimeConverter;
import com.weedow.schemaorg.serializer.converter.impl.URLConverter;
import com.weedow.schemaorg.serializer.converter.impl.XPathTypeConverter;
import com.weedow.schemaorg.serializer.deserialization.datatype.BooleanDeserializer;
import com.weedow.schemaorg.serializer.deserialization.datatype.CssSelectorTypeDeserializer;
import com.weedow.schemaorg.serializer.deserialization.datatype.DateDeserializer;
import com.weedow.schemaorg.serializer.deserialization.datatype.DateTimeDeserializer;
import com.weedow.schemaorg.serializer.deserialization.datatype.FloatDeserializer;
import com.weedow.schemaorg.serializer.deserialization.datatype.IntegerDeserializer;
import com.weedow.schemaorg.serializer.deserialization.datatype.NumberDeserializer;
import com.weedow.schemaorg.serializer.deserialization.datatype.PronounceableTextDeserializer;
import com.weedow.schemaorg.serializer.deserialization.datatype.TextDeserializer;
import com.weedow.schemaorg.serializer.deserialization.datatype.TimeDeserializer;
import com.weedow.schemaorg.serializer.deserialization.datatype.URLDeserializer;
import com.weedow.schemaorg.serializer.deserialization.datatype.XPathTypeDeserializer;
import com.weedow.schemaorg.serializer.serialization.datatype.BooleanSerializer;
import com.weedow.schemaorg.serializer.serialization.datatype.CssSelectorTypeSerializer;
import com.weedow.schemaorg.serializer.serialization.datatype.DateSerializer;
import com.weedow.schemaorg.serializer.serialization.datatype.DateTimeSerializer;
import com.weedow.schemaorg.serializer.serialization.datatype.FloatSerializer;
import com.weedow.schemaorg.serializer.serialization.datatype.IntegerSerializer;
import com.weedow.schemaorg.serializer.serialization.datatype.NumberSerializer;
import com.weedow.schemaorg.serializer.serialization.datatype.PronounceableTextSerializer;
import com.weedow.schemaorg.serializer.serialization.datatype.TextSerializer;
import com.weedow.schemaorg.serializer.serialization.datatype.TimeSerializer;
import com.weedow.schemaorg.serializer.serialization.datatype.URLSerializer;
import com.weedow.schemaorg.serializer.serialization.datatype.XPathTypeSerializer;
import com.weedow.schemaorg.serializer.spec.DataTypeSpecification;
import com.weedow.schemaorg.serializer.spec.DeserializerFunction;
import com.weedow.schemaorg.serializer.spec.SerializerFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataTypeSpecificationService {
    private static final List<DataTypeSpecification> DATA_TYPES = Arrays.asList(new DataTypeSpecification(SchemaDataType.BOOLEAN, BooleanSerializer::new, BooleanDeserializer::new, BooleanConverter.INSTANCE), new DataTypeSpecification(SchemaDataType.INTEGER, IntegerSerializer::new, IntegerDeserializer::new, IntegerConverter.INSTANCE), new DataTypeSpecification(SchemaDataType.FLOAT, FloatSerializer::new, FloatDeserializer::new, FloatConverter.INSTANCE), new DataTypeSpecification(SchemaDataType.NUMBER, NumberSerializer::new, NumberDeserializer::new, NumberConverter.INSTANCE), new DataTypeSpecification(SchemaDataType.TIME, TimeSerializer::new, TimeDeserializer::new, TimeConverter.INSTANCE), new DataTypeSpecification(SchemaDataType.DATE, DateSerializer::new, DateDeserializer::new, DateConverter.INSTANCE), new DataTypeSpecification(SchemaDataType.DATE_TIME, DateTimeSerializer::new, DateTimeDeserializer::new, DateTimeConverter.INSTANCE), new DataTypeSpecification(SchemaDataType.URL, URLSerializer::new, URLDeserializer::new, URLConverter.INSTANCE), new DataTypeSpecification(SchemaDataType.CSS_SELECTOR_TYPE, CssSelectorTypeSerializer::new, CssSelectorTypeDeserializer::new, CssSelectorTypeConverter.INSTANCE), new DataTypeSpecification(SchemaDataType.XPATH_TYPE, XPathTypeSerializer::new, XPathTypeDeserializer::new, XPathTypeConverter.INSTANCE), new DataTypeSpecification(SchemaDataType.PRONOUNCEABLE_TEXT, PronounceableTextSerializer::new, PronounceableTextDeserializer::new, PronounceableTextConverter.INSTANCE), new DataTypeSpecification(SchemaDataType.TEXT, TextSerializer::new, TextDeserializer::new, TextConverter.INSTANCE));
    private static final DataTypeSpecificationService INSTANCE = new DataTypeSpecificationService();
    private final List<String> dataTypeNames = new ArrayList<String>();
    private final Map<String, SerializerFunction> serializers = new HashMap<String, SerializerFunction>();
    private final Map<String, DeserializerFunction> deserializers = new HashMap<String, DeserializerFunction>();
    private final List<Converter<Object, ? extends JsonLdDataType<?>>> converters = new ArrayList();

    private DataTypeSpecificationService() {
        DATA_TYPES.forEach(dataTypeSpecification -> {
            String dataTypeName = dataTypeSpecification.dataType().getName();
            this.dataTypeNames.add(dataTypeName);
            this.serializers.put(dataTypeName, dataTypeSpecification.serializerFunction());
            this.deserializers.put(dataTypeName, dataTypeSpecification.deserializerFunction());
            this.converters.add(dataTypeSpecification.converter());
        });
    }

    public static DataTypeSpecificationService getInstance() {
        return INSTANCE;
    }

    public List<Converter<Object, ? extends JsonLdDataType<?>>> getConverters() {
        return this.converters;
    }

    public Comparator<Class<JsonLdDataType<?>>> getDataTypeComparator() {
        return Comparator.comparingInt(clazz -> this.dataTypeNames.indexOf(clazz.getSimpleName()));
    }

    public JsonSerializer<? extends JsonLdDataType<?>> getSerializer(Class<? extends JsonLdDataType<?>> clazz) {
        return (JsonSerializer)this.serializers.get(clazz.getSimpleName()).apply(clazz);
    }

    public JsonDeserializer<? extends JsonLdDataType<?>> getDeserializer(Class<? extends JsonLdDataType<?>> clazz) {
        return (JsonDeserializer)this.deserializers.get(clazz.getSimpleName()).apply(clazz);
    }
}

