/*
 * Decompiled with CFR 0.152.
 */
package com.weedow.schemaorg.serializer.deserialization.datatype;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.weedow.schemaorg.commons.model.JsonLdSubTypes;
import com.weedow.schemaorg.serializer.deserialization.datatype.AbstractTypeDeserializer;
import com.weedow.schemaorg.serializer.utils.SerializerUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumDeserializer
extends AbstractTypeDeserializer<Enum<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(EnumDeserializer.class);
    private final Class<?> enumType;

    public EnumDeserializer(Class<?> enumType) {
        super(enumType);
        this.enumType = enumType;
    }

    public Enum<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return EnumDeserializer.getValue(this.enumType, p.getValueAsString(), ctxt);
    }

    private static <T extends Enum<T>> T getValue(Class<?> type, String v, DeserializationContext ctxt) {
        T value = EnumDeserializer.getValue(type, v);
        return value != null ? value : EnumDeserializer.getSubTypeValue(type, v, ctxt);
    }

    private static <T extends Enum<T>> T getValue(Class<?> type, String v) {
        Object value;
        try {
            Method from = type.getDeclaredMethod("from", String.class);
            value = (Enum)from.invoke(null, v);
        }
        catch (Exception e1) {
            LOG.warn("Could not invoke method 'from': {}", (Object)e1.getMessage());
            try {
                LOG.info("Trying to invoke 'valueOf' method");
                value = Enum.valueOf(type, v);
            }
            catch (Exception e2) {
                LOG.warn("Could not invoke method 'valueOf': {}", (Object)e2.getMessage());
                value = null;
            }
        }
        return (T)value;
    }

    private static <T extends Enum<T>> T getSubTypeValue(Class<?> type, String v, DeserializationContext ctxt) {
        JsonLdSubTypes jsonLdSubTypes = type.getDeclaredAnnotation(JsonLdSubTypes.class);
        if (jsonLdSubTypes != null) {
            String[] subTypes;
            for (String subType : subTypes = jsonLdSubTypes.value()) {
                T value;
                Class<?> subClass = SerializerUtils.findClass(subType, ctxt.getTypeFactory());
                T t = value = subClass != null ? (T)EnumDeserializer.getValue(subClass, v) : null;
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }
}

