/*
 * Decompiled with CFR 0.152.
 */
package com.weedow.schemaorg.serializer.deserialization;

import com.weedow.schemaorg.commons.utils.ClassUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackageScanner {
    private static final Logger LOG = LoggerFactory.getLogger(PackageScanner.class);
    private static final String CLASS_EXTENSION = ".class";
    private static final int CLASS_EXTENSION_SIZE = ".class".length();
    private static final Comparator<Class<?>> CLASS_COMPARATOR = Comparator.comparing(Class::getName);

    private PackageScanner() {
    }

    public static Set<Class<?>> getClassesIn(String packageName) {
        return PackageScanner.getClassesIn(packageName, (Class)null);
    }

    public static Set<Class<?>> getClassesIn(String packageName, Class<?> isAssignableFrom) {
        Set<Class<?>> classes = PackageScanner.getClassesIn(packageName, (String)null);
        if (isAssignableFrom == null) {
            return classes;
        }
        LinkedHashSet filteredList = new LinkedHashSet();
        for (Class<?> clazz : classes) {
            if (!isAssignableFrom.isAssignableFrom(clazz)) continue;
            filteredList.add(clazz);
        }
        return filteredList;
    }

    public static Set<Class<?>> getClassesIn(String packageName, String regexFilter) {
        Pattern regex = regexFilter != null ? Pattern.compile(regexFilter) : null;
        try {
            ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
            String path = packageName.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(path);
            ArrayList<String> dirs = new ArrayList<String>();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                dirs.add(PackageScanner.resolveDir(resource));
            }
            TreeSet classes = new TreeSet(CLASS_COMPARATOR);
            for (String directory : dirs) {
                classes.addAll(PackageScanner.findClasses(directory, packageName, regex));
            }
            return classes;
        }
        catch (Exception e) {
            LOG.warn("Could not get classes from package {}: {}", new Object[]{packageName, e.getMessage(), e});
            return Collections.emptySet();
        }
    }

    private static String resolveDir(URL resource) throws URISyntaxException {
        String path = resource.toURI().getPath();
        return path != null ? path : resource.getFile();
    }

    private static Set<Class<?>> findClasses(String path, String packageName, Pattern regex) throws IOException {
        TreeSet classes = new TreeSet(CLASS_COMPARATOR);
        PackageScanner.findClassesInJar(classes, path, packageName, regex);
        File dir = new File(path);
        if (!dir.exists()) {
            return classes;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    assert (!file.getName().contains("."));
                    classes.addAll(PackageScanner.findClasses(file.getAbsolutePath(), packageName + "." + file.getName(), regex));
                    continue;
                }
                if (!file.getName().endsWith(CLASS_EXTENSION)) continue;
                String className = packageName + "." + file.getName().substring(0, file.getName().length() - CLASS_EXTENSION_SIZE);
                if (regex != null && !regex.matcher(className).matches()) continue;
                classes.add(PackageScanner.forName(className));
            }
        }
        return classes;
    }

    private static void findClassesInJar(Set<Class<?>> classes, String path, String packageName, Pattern regex) throws IOException {
        if (path.startsWith("file:") && path.contains("!")) {
            String[] split = path.split("!");
            URL jar = new URL(split[0]);
            try (ZipInputStream zip = new ZipInputStream(jar.openStream());){
                ZipEntry entry;
                while ((entry = zip.getNextEntry()) != null) {
                    String className;
                    if (entry.getName().endsWith(CLASS_EXTENSION) && (className = entry.getName().replaceAll("[$].*", "").replaceAll("[.]class", "").replace('/', '.')).startsWith(packageName) && (regex == null || regex.matcher(className).matches())) {
                        classes.add(PackageScanner.forName(className));
                    }
                    zip.closeEntry();
                }
            }
        }
    }

    private static Class<?> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Could not resolve class {}", (Object)className, (Object)e);
            return null;
        }
    }
}

