/*
 * Decompiled with CFR 0.152.
 */
package com.weedow.schemaorg.serializer.converter.impl;

import com.weedow.schemaorg.commons.model.JsonLdDataType;
import com.weedow.schemaorg.serializer.converter.impl.AbstractConverter;

public class NumberConverter
extends AbstractConverter {
    public static final NumberConverter INSTANCE = new NumberConverter();

    private NumberConverter() {
    }

    @Override
    public boolean supports(Class<? extends JsonLdDataType<?>> jsonLdDataType, Class<?> targetType) {
        return (Number.class.isAssignableFrom(targetType) || String.class.isAssignableFrom(targetType)) && jsonLdDataType.getSimpleName().equals("Number");
    }

    @Override
    public Number getValue(Object source) {
        Number number;
        if (source instanceof Number) {
            Number value = (Number)source;
            number = value;
        } else {
            number = Double.valueOf(source.toString());
        }
        return number;
    }
}

