/*
 * Decompiled with CFR 0.152.
 */
package com.weedow.schemaorg.serializer.converter.impl;

import com.weedow.schemaorg.commons.model.JsonLdDataType;
import com.weedow.schemaorg.serializer.converter.impl.AbstractConverter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class DateTimeConverter
extends AbstractConverter {
    public static final DateTimeConverter INSTANCE = new DateTimeConverter();

    private DateTimeConverter() {
    }

    @Override
    public boolean supports(Class<? extends JsonLdDataType<?>> jsonLdDataType, Class<?> targetType) {
        return (LocalDateTime.class.isAssignableFrom(targetType) || String.class.isAssignableFrom(targetType)) && jsonLdDataType.getSimpleName().equals("DateTime");
    }

    @Override
    public LocalDateTime getValue(Object source) {
        LocalDateTime localDateTime;
        return source instanceof LocalDateTime ? (localDateTime = (LocalDateTime)source) : LocalDateTime.parse(source.toString(), DateTimeFormatter.ISO_DATE_TIME);
    }
}

