/*
 * Copyright 2013 websudos ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.websudos.phantom.column

import scala.annotation.implicitNotFound
import com.datastax.driver.core.Row
import com.websudos.phantom.{ CassandraPrimitive, CassandraTable }

@implicitNotFound(msg = "Type ${T} must be a Cassandra primitive")
class OptionalPrimitiveColumn[Owner <: CassandraTable[Owner, Record], Record, @specialized(Int, Double, Float, Long, Boolean,
  Short) T : CassandraPrimitive](t: CassandraTable[Owner, Record]) extends OptionalColumn[Owner, Record, T](t) {

  def cassandraType: String = CassandraPrimitive[T].cassandraType

  def optional(r: Row): Option[T] = implicitly[CassandraPrimitive[T]].fromRow(r, name)

  def toCType(v: Option[T]): AnyRef = v map implicitly[CassandraPrimitive[T]].toCType getOrElse null
}
