/*
 * Decompiled with CFR 0.152.
 */
package com.webkul.mobikul.mobikuldialoglibrary;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import com.webkul.mobikul.mobikuldialoglibrary.R;
import com.webkul.mobikul.mobikuldialoglibrary.databinding.DialogCustomBinding;

public class CustomDialog
extends Dialog
implements View.OnClickListener {
    private DialogCustomBinding binding;
    private String mTitleHeading = "";
    private String mSubTitle = "";
    private String mPositiveButtontext = "";
    private String mNegativeButtontext = "";
    private Drawable mIcon;
    private Context mContext;
    private int mTitleTextSize = 20;
    private int mSubTitleTextSize = 16;
    private boolean mButtonEnabled = false;
    private boolean mNegativeButtonEnabled = false;
    private boolean dismissOnBackPress = true;
    private Drawable mPositiveButtonBackgroundDrawable;
    private Drawable mNegativeButtonBackgroundDrawable;
    @ColorInt
    private int mPositiveButtonBackgroundColor;
    @ColorInt
    private int mButtonTextColor;
    @ColorInt
    private int mNegativeButtonBackgroundColor;
    private int mButtonsOrientation = 0;
    private int mButtonsGravity = 0x800005;
    private String mIconUrl;
    private CustomDialogButtonClickListener positiveButtonClickListener = null;
    private CustomDialogButtonClickListener negativeButtonClickListener = null;

    public CustomDialog(@NonNull Context context) {
        this(context, Type.NORMAL_TYPE_DIALOG);
    }

    public CustomDialog(@NonNull Context context, Type type) {
        super(context);
        this.mContext = context;
        if (this.getWindow() != null) {
            this.requestWindowFeature(1);
            this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
        this.binding = DialogCustomBinding.inflate((LayoutInflater)LayoutInflater.from((Context)context), null, (boolean)false);
        this.setContentView(this.binding.getRoot());
        this.setType(type);
    }

    public static CustomDialog getInstantDialog(@NonNull Context context, @NonNull Type type) {
        CustomDialog customDialog = new CustomDialog(context, type);
        customDialog.setPositiveButtonText(17039370).setPositiveButtonEnabled(true).setTitleTextSize(22).setSubTitleTextSize(16).setDismissOnBackPress(false).setCanceledOnTouchOutside(false);
        switch (type) {
            case SUCCESS_TYPE_DIALOG: {
                customDialog.setIcon(R.drawable.ic_vector_custom_dialog_success_icon).setTitleHeading(R.string.success).setSubTitle(R.string.process_is_successful).setPositiveButtonEnabled(false).setButtonsGravity(17).setDismissOnBackPress(true).setCanceledOnTouchOutside(true);
                break;
            }
            case ERROR_TYPE_DIALOG: {
                customDialog.setIcon(R.drawable.ic_vector_custom_dialog_error_icon).setTitleHeading(R.string.error).setButtonsGravity(17).setSubTitle(R.string.error_occured_please_try_again);
                break;
            }
            case WARNING_TYPE_DIALOG: {
                customDialog.setIcon(R.drawable.ic_vector_custom_dialog_warning_icon).setTitleHeading(R.string.warning).setButtonsGravity(17).setSubTitle(R.string.warning_mesaage);
                break;
            }
        }
        if (Build.VERSION.SDK_INT >= 23) {
            customDialog.setButtonTextColor(context.getResources().getColor(17170443, null));
        } else {
            customDialog.setButtonTextColor(context.getResources().getColor(17170443));
        }
        return customDialog;
    }

    public CustomDialog setType(Type type) {
        switch (type) {
            case SUCCESS_TYPE_DIALOG: {
                this.setIcon(R.drawable.ic_vector_custom_dialog_success_icon);
                break;
            }
            case ERROR_TYPE_DIALOG: {
                this.setIcon(R.drawable.ic_vector_custom_dialog_error_icon);
                break;
            }
            case WARNING_TYPE_DIALOG: {
                this.setIcon(R.drawable.ic_vector_custom_dialog_warning_icon);
                break;
            }
        }
        return this;
    }

    public CustomDialog setTitleHeading(@StringRes int text) {
        this.mTitleHeading = this.mContext.getString(text);
        return this;
    }

    public CustomDialog setTitleHeading(String text) {
        this.mTitleHeading = text;
        return this;
    }

    public CustomDialog setSubTitle(@StringRes int text) {
        this.mSubTitle = this.mContext.getString(text);
        return this;
    }

    public CustomDialog setSubTitle(String text) {
        this.mSubTitle = text;
        return this;
    }

    public CustomDialog setTitleTextSize(int testSize) {
        this.mTitleTextSize = testSize;
        return this;
    }

    public CustomDialog setSubTitleTextSize(int testSize) {
        this.mSubTitleTextSize = testSize;
        return this;
    }

    public CustomDialog setIcon(@DrawableRes int resource) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.mContext, (int)resource);
        return this.setIcon(drawable2);
    }

    public CustomDialog setIcon(Drawable drawable2) {
        this.mIcon = drawable2;
        return this;
    }

    public CustomDialog setPositiveButtonText(@StringRes int text) {
        this.mPositiveButtontext = this.mContext.getString(text);
        return this;
    }

    public CustomDialog setPositiveButtonText(String text) {
        this.mPositiveButtontext = text;
        return this;
    }

    public CustomDialog setNegativeButtonText(@StringRes int text) {
        this.mNegativeButtontext = this.mContext.getString(text);
        return this;
    }

    public CustomDialog setNegativeButtonText(String text) {
        this.mNegativeButtontext = text;
        return this;
    }

    public CustomDialog setPositiveButtonBackground(@DrawableRes int resource) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.mContext, (int)resource);
        return this.setPositiveButtonBackground(drawable2);
    }

    public CustomDialog setNegativeButtonBackground(@DrawableRes int resource) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.mContext, (int)resource);
        return this.setNegativeButtonBackground(drawable2);
    }

    public CustomDialog setPositiveButtonBackground(Drawable drawable2) {
        this.mPositiveButtonBackgroundDrawable = drawable2;
        return this;
    }

    public CustomDialog setNegativeButtonBackground(Drawable drawable2) {
        this.mNegativeButtonBackgroundDrawable = drawable2;
        return this;
    }

    public CustomDialog setPositiveButtonBackgroundColor(@ColorInt int color2) {
        this.mPositiveButtonBackgroundColor = color2;
        return this;
    }

    public CustomDialog setNegativeButtonBackgroundColor(@ColorInt int color2) {
        this.mNegativeButtonBackgroundColor = color2;
        return this;
    }

    public CustomDialog setPositiveButtonEnabled(boolean enabled) {
        this.mButtonEnabled = enabled;
        return this;
    }

    public CustomDialog setNegativeButtonEnabled(boolean enabled) {
        this.mNegativeButtonEnabled = enabled;
        return this;
    }

    public CustomDialog setButtonsOrientation(int orientation) {
        this.mButtonsOrientation = orientation;
        return this;
    }

    public CustomDialog setButtonsGravity(int gravity) {
        this.mButtonsGravity = gravity;
        return this;
    }

    public CustomDialog setButtonTextColor(@ColorInt int color2) {
        this.mButtonTextColor = color2;
        return this;
    }

    public CustomDialog setDismissOnBackPress(boolean dismissOnBackPress) {
        this.dismissOnBackPress = dismissOnBackPress;
        return this;
    }

    public void onBackPressed() {
        if (this.dismissOnBackPress) {
            super.onBackPressed();
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!this.mTitleHeading.isEmpty()) {
            this.binding.heading.setVisibility(0);
            this.binding.heading.setText((CharSequence)this.mTitleHeading);
        } else {
            this.binding.heading.setVisibility(8);
        }
        if (!this.mSubTitle.isEmpty()) {
            this.binding.subheading.setVisibility(0);
            this.binding.subheading.setText((CharSequence)this.mSubTitle);
        } else {
            this.binding.subheading.setVisibility(8);
        }
        this.binding.heading.setTextSize((float)this.mTitleTextSize);
        this.binding.subheading.setTextSize((float)this.mSubTitleTextSize);
        if (this.mIcon != null) {
            this.binding.icon.setVisibility(0);
            this.binding.icon.setImageDrawable(this.mIcon);
        } else if (this.binding.icon.getDrawable() != null) {
            this.binding.icon.setVisibility(0);
        } else {
            this.binding.icon.setVisibility(8);
        }
        this.binding.positiveButton.setVisibility(this.mButtonEnabled ? 0 : 8);
        this.binding.negativeButton.setVisibility(this.mNegativeButtonEnabled ? 0 : 8);
        this.binding.positiveButton.setText((CharSequence)this.mPositiveButtontext);
        this.binding.negativeButton.setText((CharSequence)this.mNegativeButtontext);
        if (this.mButtonTextColor != 0) {
            this.binding.positiveButton.setTextColor(this.mButtonTextColor);
            this.binding.negativeButton.setTextColor(this.mButtonTextColor);
        }
        if (this.mPositiveButtonBackgroundColor != 0) {
            this.binding.positiveButton.setBackgroundColor(this.mPositiveButtonBackgroundColor);
        }
        if (this.mNegativeButtonBackgroundColor != 0) {
            this.binding.negativeButton.setBackgroundColor(this.mNegativeButtonBackgroundColor);
        }
        if (this.mPositiveButtonBackgroundDrawable != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.binding.positiveButton.setBackground(this.mPositiveButtonBackgroundDrawable);
            } else {
                this.binding.positiveButton.setBackgroundDrawable(this.mPositiveButtonBackgroundDrawable);
            }
        }
        if (this.mNegativeButtonBackgroundDrawable != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.binding.negativeButton.setBackground(this.mNegativeButtonBackgroundDrawable);
            } else {
                this.binding.negativeButton.setBackgroundDrawable(this.mNegativeButtonBackgroundDrawable);
            }
        }
        this.binding.positiveButton.setOnClickListener((View.OnClickListener)this);
        this.binding.negativeButton.setOnClickListener((View.OnClickListener)this);
        this.binding.buttonLayout.setOrientation(this.mButtonsOrientation);
        this.binding.buttonLayout.setGravity(this.mButtonsGravity);
    }

    public CustomDialog setPositiveButtonClickListener(CustomDialogButtonClickListener positiveButtonClickListener) {
        this.positiveButtonClickListener = positiveButtonClickListener;
        return this;
    }

    public CustomDialog setNegativeButtonClickListener(CustomDialogButtonClickListener negativeButtonClickListener) {
        this.negativeButtonClickListener = negativeButtonClickListener;
        return this;
    }

    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.positiveButton) {
            if (this.positiveButtonClickListener != null) {
                this.positiveButtonClickListener.onClick(this);
            } else {
                this.dismiss();
            }
        } else if (viewId == R.id.negativeButton) {
            if (this.negativeButtonClickListener != null) {
                this.negativeButtonClickListener.onClick(this);
            } else {
                this.dismiss();
            }
        }
    }

    public ImageView getIconview() {
        return this.binding.icon;
    }

    public CustomDialog addMoreViews(View view) {
        this.binding.extraViewContainer.addView(view);
        return this;
    }

    public static interface CustomDialogButtonClickListener {
        public void onClick(CustomDialog var1);
    }

    public static enum Type {
        SUCCESS_TYPE_DIALOG,
        ERROR_TYPE_DIALOG,
        WARNING_TYPE_DIALOG,
        NORMAL_TYPE_DIALOG,
        CUSTOM_TYPE_DIALOG;

    }
}

