/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.model;

import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedTypeElement;
import com.webcohesion.enunciate.javac.decorations.type.TypeVariableContext;
import com.webcohesion.enunciate.modules.spring_web.EnunciateSpringWebContext;
import com.webcohesion.enunciate.modules.spring_web.model.PathSegment;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMapping;
import java.lang.annotation.IncompleteAnnotationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.security.RolesAllowed;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.springframework.web.bind.annotation.RequestMethod;

public class SpringController
extends DecoratedTypeElement
implements HasFacets {
    private final EnunciateSpringWebContext context;
    private final Set<String> paths;
    private final Set<String> consumesMime;
    private final Set<String> producesMime;
    private final org.springframework.web.bind.annotation.RequestMapping mappingInfo;
    private final List<RequestMapping> requestMappings;
    private final Set<Facet> facets = new TreeSet<Facet>();

    public SpringController(TypeElement delegate, EnunciateSpringWebContext context) {
        this(delegate, delegate.getAnnotation(org.springframework.web.bind.annotation.RequestMapping.class), context);
    }

    private SpringController(TypeElement delegate, org.springframework.web.bind.annotation.RequestMapping mappingInfo, EnunciateSpringWebContext context) {
        this(delegate, SpringController.loadPaths(mappingInfo), mappingInfo, context);
    }

    private static Set<String> loadPaths(org.springframework.web.bind.annotation.RequestMapping mappingInfo) {
        TreeSet<String> paths = new TreeSet<String>();
        if (mappingInfo != null) {
            try {
                paths.addAll(Arrays.asList(mappingInfo.path()));
            }
            catch (IncompleteAnnotationException incompleteAnnotationException) {
                // empty catch block
            }
            paths.addAll(Arrays.asList(mappingInfo.value()));
        }
        if (paths.isEmpty()) {
            paths.add("");
        }
        return paths;
    }

    private SpringController(TypeElement delegate, Set<String> paths, org.springframework.web.bind.annotation.RequestMapping mappingInfo, EnunciateSpringWebContext context) {
        super(delegate, (ProcessingEnvironment)context.getContext().getProcessingEnvironment());
        this.context = context;
        this.paths = paths;
        this.mappingInfo = mappingInfo;
        TreeSet<String> consumes = new TreeSet<String>();
        if (mappingInfo != null && mappingInfo.consumes().length > 0) {
            for (String mt : mappingInfo.consumes()) {
                if (mt.startsWith("!")) continue;
                consumes.add(mt);
            }
        } else {
            consumes.add("*/*");
        }
        this.consumesMime = Collections.unmodifiableSet(consumes);
        TreeSet<String> produces = new TreeSet<String>();
        if (mappingInfo != null && mappingInfo.produces().length > 0) {
            for (String mt : mappingInfo.produces()) {
                if (mt.startsWith("!")) continue;
                produces.add(mt);
            }
        } else {
            produces.add("*/*");
        }
        this.producesMime = Collections.unmodifiableSet(produces);
        this.facets.addAll(Facet.gatherFacets((Element)delegate));
        this.requestMappings = Collections.unmodifiableList(this.getRequestMappings(delegate, new TypeVariableContext(), context));
    }

    protected List<RequestMapping> getRequestMappings(TypeElement delegate, TypeVariableContext variableContext, EnunciateSpringWebContext context) {
        TypeMirror superclass;
        if (delegate == null || delegate.getQualifiedName().toString().equals(Object.class.getName())) {
            return Collections.emptyList();
        }
        ArrayList<RequestMapping> requestMappings = new ArrayList<RequestMapping>();
        for (ExecutableElement executableElement : ElementFilter.methodsIn(delegate.getEnclosedElements())) {
            org.springframework.web.bind.annotation.RequestMapping mappingInfo = executableElement.getAnnotation(org.springframework.web.bind.annotation.RequestMapping.class);
            if (mappingInfo == null) continue;
            TreeSet<String> subpaths = new TreeSet<String>();
            try {
                subpaths.addAll(Arrays.asList(mappingInfo.path()));
            }
            catch (IncompleteAnnotationException e) {
                // empty catch block
            }
            subpaths.addAll(Arrays.asList(mappingInfo.value()));
            if (subpaths.isEmpty()) {
                subpaths.add("");
            }
            for (String path : this.getPaths()) {
                for (String subpath : subpaths) {
                    requestMappings.add(new RequestMapping(SpringController.extractPathComponents(path + subpath), mappingInfo, executableElement, this, variableContext, context));
                }
            }
            if (!requestMappings.isEmpty()) continue;
            requestMappings.add(new RequestMapping(new ArrayList<PathSegment>(), mappingInfo, executableElement, this, variableContext, context));
        }
        for (TypeMirror typeMirror : delegate.getInterfaces()) {
            if (!(typeMirror instanceof DeclaredType)) continue;
            DeclaredType declared = (DeclaredType)typeMirror;
            TypeElement element = (TypeElement)declared.asElement();
            List<RequestMapping> interfaceMethods = this.getRequestMappings(element, variableContext.push(element.getTypeParameters(), declared.getTypeArguments()), context);
            for (RequestMapping interfaceMethod : interfaceMethods) {
                if (this.isOverridden((ExecutableElement)((Object)interfaceMethod), requestMappings)) continue;
                requestMappings.add(interfaceMethod);
            }
        }
        if (delegate.getKind() == ElementKind.CLASS && (superclass = delegate.getSuperclass()) instanceof DeclaredType && ((DeclaredType)superclass).asElement() != null) {
            DeclaredType declaredType = (DeclaredType)superclass;
            TypeElement element = (TypeElement)declaredType.asElement();
            List<RequestMapping> superMethods = this.getRequestMappings(element, variableContext.push(element.getTypeParameters(), declaredType.getTypeArguments()), context);
            for (RequestMapping superMethod : superMethods) {
                if (this.isOverridden((ExecutableElement)((Object)superMethod), requestMappings)) continue;
                requestMappings.add(superMethod);
            }
        }
        return requestMappings;
    }

    private static List<PathSegment> extractPathComponents(String path) {
        ArrayList<PathSegment> components = new ArrayList<PathSegment>();
        if (path != null) {
            StringTokenizer tokenizer = new StringTokenizer(path, "/");
            while (tokenizer.hasMoreTokens()) {
                String prefix = "/";
                String component = tokenizer.nextToken().trim();
                if (component.isEmpty()) continue;
                StringBuilder value = new StringBuilder();
                StringBuilder variable = new StringBuilder();
                StringBuilder regexp = new StringBuilder();
                int charIndex = 0;
                int inBrace = 0;
                boolean definingRegexp = false;
                while (charIndex < component.length()) {
                    char ch;
                    if ((ch = component.charAt(charIndex++)) == '{') {
                        ++inBrace;
                        if (value.length() > 0) {
                            components.add(new PathSegment(prefix, value.toString(), variable.length() > 0 ? variable.toString() : null, regexp.length() > 0 ? regexp.toString() : null));
                            prefix = "";
                            value = new StringBuilder();
                            variable = new StringBuilder();
                            regexp = new StringBuilder();
                        }
                    } else if (ch == '}') {
                        if (--inBrace == 0) {
                            definingRegexp = false;
                        }
                        if (value.length() > 0) {
                            components.add(new PathSegment(prefix, value.toString(), variable.length() > 0 ? variable.toString() : null, regexp.length() > 0 ? regexp.toString() : null));
                            prefix = "";
                            value = new StringBuilder();
                            variable = new StringBuilder();
                            regexp = new StringBuilder();
                        }
                    } else {
                        if (inBrace == 1 && ch == ':') {
                            definingRegexp = true;
                            continue;
                        }
                        if (!definingRegexp && !Character.isWhitespace(ch)) {
                            variable.append(ch);
                        }
                    }
                    if (definingRegexp) {
                        regexp.append(ch);
                        continue;
                    }
                    if (Character.isWhitespace(ch)) continue;
                    value.append(ch);
                }
                if (value.length() <= 0) continue;
                components.add(new PathSegment(prefix, value.toString(), variable.length() > 0 ? variable.toString() : null, regexp.length() > 0 ? regexp.toString() : null));
            }
        }
        return components;
    }

    protected boolean isOverridden(ExecutableElement method, ArrayList<? extends ExecutableElement> resourceMethods) {
        Elements decls = this.env.getElementUtils();
        for (ExecutableElement executableElement : resourceMethods) {
            if (!decls.overrides(executableElement, method, (TypeElement)executableElement.getEnclosingElement())) continue;
            return true;
        }
        return false;
    }

    public EnunciateSpringWebContext getContext() {
        return this.context;
    }

    public final Set<String> getPaths() {
        return this.paths;
    }

    public Set<String> getConsumesMime() {
        return this.consumesMime;
    }

    public Set<String> getProducesMime() {
        return this.producesMime;
    }

    public List<RequestMapping> getRequestMappings() {
        return this.requestMappings;
    }

    public Set<Facet> getFacets() {
        return this.facets;
    }

    public Set<RequestMethod> getApplicableMethods() {
        RequestMethod[] methods;
        EnumSet<RequestMethod> applicableMethods = EnumSet.allOf(RequestMethod.class);
        if (this.mappingInfo != null && (methods = this.mappingInfo.method()).length > 0) {
            applicableMethods.retainAll(Arrays.asList(methods));
        }
        return applicableMethods;
    }

    public Set<String> getSecurityRoles() {
        TreeSet<String> roles = new TreeSet<String>();
        RolesAllowed rolesAllowed = (RolesAllowed)this.getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            Collections.addAll(roles, rolesAllowed.value());
        }
        return roles;
    }
}

