/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.model;

import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedExecutableElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.javac.decorations.type.TypeVariableContext;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.metadata.rs.ResourceLabel;
import com.webcohesion.enunciate.metadata.rs.ResponseHeader;
import com.webcohesion.enunciate.metadata.rs.ResponseHeaders;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import com.webcohesion.enunciate.metadata.rs.Warnings;
import com.webcohesion.enunciate.modules.spring_web.EnunciateSpringWebContext;
import com.webcohesion.enunciate.modules.spring_web.model.PathContext;
import com.webcohesion.enunciate.modules.spring_web.model.PathSegment;
import com.webcohesion.enunciate.modules.spring_web.model.RequestParameter;
import com.webcohesion.enunciate.modules.spring_web.model.RequestParameterFactory;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceEntityParameter;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceMethodMediaType;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceRepresentationMetadata;
import com.webcohesion.enunciate.modules.spring_web.model.ResponseCode;
import com.webcohesion.enunciate.modules.spring_web.model.SpringController;
import com.webcohesion.enunciate.util.TypeHintUtils;
import java.lang.annotation.IncompleteAnnotationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.security.RolesAllowed;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

public class RequestMapping
extends DecoratedExecutableElement
implements HasFacets,
PathContext {
    private static final Pattern CONTEXT_PARAM_PATTERN = Pattern.compile("\\{([^\\}]+)\\}");
    private final EnunciateSpringWebContext context;
    private final List<PathSegment> pathSegments;
    private final String label;
    private final Set<String> httpMethods;
    private final Set<String> consumesMediaTypes;
    private final Set<String> producesMediaTypes;
    private final SpringController parent;
    private final Set<RequestParameter> requestParameters;
    private final ResourceEntityParameter entityParameter;
    private final Map<String, Object> metaData = new HashMap<String, Object>();
    private final List<? extends ResponseCode> statusCodes;
    private final List<? extends ResponseCode> warnings;
    private final Map<String, String> responseHeaders = new HashMap<String, String>();
    private final ResourceRepresentationMetadata representationMetadata;
    private final Set<Facet> facets = new TreeSet<Facet>();

    public RequestMapping(List<PathSegment> pathSegments, org.springframework.web.bind.annotation.RequestMapping mappingInfo, ExecutableElement delegate, SpringController parent, TypeVariableContext variableContext, EnunciateSpringWebContext context) {
        super(delegate, (ProcessingEnvironment)context.getContext().getProcessingEnvironment());
        ResponseHeaders responseHeaders;
        Warnings warningInfo;
        ResponseStatus responseStatus;
        DecoratedTypeMirror returnType;
        this.context = context;
        this.pathSegments = pathSegments;
        EnumSet<RequestMethod> httpMethods = EnumSet.allOf(RequestMethod.class);
        RequestMethod[] methods = mappingInfo.method();
        if (methods.length > 0) {
            httpMethods.retainAll(Arrays.asList(methods));
        }
        httpMethods.retainAll(parent.getApplicableMethods());
        if (httpMethods.isEmpty()) {
            throw new IllegalStateException(parent.getQualifiedName() + "." + this.getSimpleName() + ": no applicable request methods.");
        }
        this.httpMethods = new TreeSet<String>();
        for (RequestMethod httpMethod : httpMethods) {
            this.httpMethods.add(httpMethod.name());
        }
        Set<Object> consumes = new TreeSet();
        String[] consumesInfo = mappingInfo.consumes();
        if (consumesInfo.length > 0) {
            for (String mediaType : consumesInfo) {
                if (mediaType.startsWith("!")) continue;
                consumes.add(mediaType);
            }
            if (consumes.isEmpty()) {
                consumes.add("*/*");
            }
        } else {
            consumes = parent.getConsumesMime();
        }
        this.consumesMediaTypes = consumes;
        Set<Object> produces = new TreeSet();
        String[] producesInfo = mappingInfo.produces();
        if (producesInfo.length > 0) {
            for (String mediaType : producesInfo) {
                if (mediaType.startsWith("!")) continue;
                produces.add(mediaType);
            }
            if (produces.isEmpty()) {
                produces.add("*/*");
            }
        } else {
            produces = parent.getProducesMime();
        }
        this.producesMediaTypes = produces;
        String label = null;
        ResourceLabel resourceLabel = delegate.getAnnotation(ResourceLabel.class);
        if (resourceLabel != null && "##default".equals(label = resourceLabel.value())) {
            label = null;
        }
        ResourceEntityParameter entityParameter = null;
        TreeSet<RequestParameter> requestParameters = new TreeSet<RequestParameter>();
        for (VariableElement parameterDeclaration : this.getParameters()) {
            requestParameters.addAll(RequestParameterFactory.getRequestParameters(this, parameterDeclaration, this));
            if (parameterDeclaration.getAnnotation(RequestBody.class) == null) continue;
            entityParameter = new ResourceEntityParameter(this, parameterDeclaration, variableContext, context);
        }
        TypeHint hintInfo = (TypeHint)this.getAnnotation(TypeHint.class);
        if (hintInfo != null) {
            returnType = (DecoratedTypeMirror)TypeHintUtils.getTypeHint((TypeHint)hintInfo, (ProcessingEnvironment)this.env, null);
            if (returnType != null) {
                returnType.setDocComment(((DecoratedTypeMirror)this.getReturnType()).getDocComment());
            }
        } else {
            boolean returnsResponseBody;
            returnType = (DecoratedTypeMirror)this.getReturnType();
            String docComment = returnType.getDocComment();
            if (returnType instanceof DecoratedDeclaredType && (returnType.isInstanceOf(Callable.class) || returnType.isInstanceOf(DeferredResult.class) || returnType.isInstanceOf("org.springframework.util.concurrent.ListenableFuture"))) {
                List typeArgs = ((DecoratedDeclaredType)returnType).getTypeArguments();
                returnType = typeArgs != null && typeArgs.size() == 1 ? (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)((TypeMirror)typeArgs.get(0)), (ProcessingEnvironment)this.env) : TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)this.env);
            }
            boolean bl = returnsResponseBody = this.getAnnotation(ResponseBody.class) != null || parent.getAnnotation(ResponseBody.class) != null || parent.getAnnotation(RestController.class) != null;
            if (returnType instanceof DecoratedDeclaredType && returnType.isInstanceOf("org.springframework.http.HttpEntity")) {
                DecoratedDeclaredType entity = (DecoratedDeclaredType)returnType;
                List typeArgs = entity.getTypeArguments();
                returnType = typeArgs != null && typeArgs.size() == 1 ? (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)((TypeMirror)typeArgs.get(0)), (ProcessingEnvironment)this.env) : TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)this.env);
            } else if (!returnsResponseBody) {
                returnType = TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)this.env);
            }
            returnType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)variableContext.resolveTypeVariables((TypeMirror)returnType, (ProcessingEnvironment)this.env), (ProcessingEnvironment)this.env);
            returnType.setDocComment(docComment);
        }
        ResourceRepresentationMetadata outputPayload = returnType == null || returnType.isVoid() ? null : new ResourceRepresentationMetadata(returnType);
        ArrayList<? extends ResponseCode> statusCodes = new ArrayList<ResponseCode>();
        ArrayList<? extends ResponseCode> warnings = new ArrayList<ResponseCode>();
        StatusCodes codes = (StatusCodes)this.getAnnotation(StatusCodes.class);
        if (codes != null) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode code : codes.value()) {
                ResponseCode rc = new ResponseCode();
                rc.setCode(code.code());
                rc.setCondition(code.condition());
                for (ResponseHeader header : code.additionalHeaders()) {
                    rc.setAdditionalHeader(header.name(), header.description());
                }
                statusCodes.add(rc);
            }
        }
        if ((responseStatus = (ResponseStatus)this.getAnnotation(ResponseStatus.class)) != null) {
            HttpStatus code = responseStatus.value();
            if (code == HttpStatus.INTERNAL_SERVER_ERROR) {
                try {
                    code = responseStatus.code();
                }
                catch (IncompleteAnnotationException e) {
                    // empty catch block
                }
            }
            ResponseCode rc = new ResponseCode();
            rc.setCode(code.value());
            String reason = responseStatus.reason();
            if (!reason.isEmpty()) {
                rc.setCondition(reason);
            }
            statusCodes.add(rc);
        }
        if ((warningInfo = (Warnings)this.getAnnotation(Warnings.class)) != null) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode code : warningInfo.value()) {
                ResponseCode rc = new ResponseCode();
                rc.setCode(code.code());
                rc.setCondition(code.condition());
                warnings.add(rc);
            }
        }
        if ((codes = (StatusCodes)parent.getAnnotation(StatusCodes.class)) != null) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode code : codes.value()) {
                ResponseCode rc = new ResponseCode();
                rc.setCode(code.code());
                rc.setCondition(code.condition());
                statusCodes.add(rc);
            }
        }
        if ((warningInfo = (Warnings)parent.getAnnotation(Warnings.class)) != null) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode code : warningInfo.value()) {
                ResponseCode rc = new ResponseCode();
                rc.setCode(code.code());
                rc.setCondition(code.condition());
                warnings.add(rc);
            }
        }
        if ((responseHeaders = (ResponseHeaders)parent.getAnnotation(ResponseHeaders.class)) != null) {
            for (ResponseHeader header : responseHeaders.value()) {
                this.responseHeaders.put(header.name(), header.description());
            }
        }
        if ((responseHeaders = (ResponseHeaders)this.getAnnotation(ResponseHeaders.class)) != null) {
            for (ResponseHeader header : responseHeaders.value()) {
                this.responseHeaders.put(header.name(), header.description());
            }
        }
        this.entityParameter = entityParameter;
        this.requestParameters = requestParameters;
        this.label = label;
        this.parent = parent;
        this.statusCodes = statusCodes;
        this.warnings = warnings;
        this.representationMetadata = outputPayload;
        this.facets.addAll(Facet.gatherFacets((Element)delegate));
        this.facets.addAll(parent.getFacets());
    }

    protected static HashMap<String, String> parseParamComments(String tagName, JavaDoc jd) {
        HashMap<String, String> paramComments = new HashMap<String, String>();
        if (jd.get((Object)tagName) != null) {
            for (String paramDoc : (JavaDoc.JavaDocTagList)jd.get((Object)tagName)) {
                int spaceIndex = (paramDoc = paramDoc.trim().replaceFirst("\\s+", " ")).indexOf(32);
                if (spaceIndex == -1) {
                    spaceIndex = paramDoc.length();
                }
                String param = paramDoc.substring(0, spaceIndex);
                String paramComment = "";
                if (spaceIndex + 1 < paramDoc.length()) {
                    paramComment = paramDoc.substring(spaceIndex + 1);
                }
                paramComments.put(param, paramComment);
            }
        }
        return paramComments;
    }

    protected HashMap<String, String> loadParamsComments(JavaDoc jd) {
        HashMap<String, String> paramRESTComments = RequestMapping.parseParamComments("RSParam", jd);
        HashMap<String, String> paramComments = RequestMapping.parseParamComments("param", jd);
        paramComments.putAll(paramRESTComments);
        return paramComments;
    }

    @Override
    public EnunciateSpringWebContext getContext() {
        return this.context;
    }

    public Set<String> getHttpMethods() {
        return this.httpMethods;
    }

    @Override
    public List<PathSegment> getPathSegments() {
        return this.pathSegments;
    }

    public String getFullpath() {
        StringBuilder builder = new StringBuilder();
        for (PathSegment pathSegment : this.getPathSegments()) {
            builder.append(pathSegment.getPrefix()).append(pathSegment.getValue());
        }
        return builder.toString();
    }

    public String getServletPattern() {
        StringBuilder builder = new StringBuilder();
        String fullPath = this.getFullpath();
        Matcher pathParamMatcher = CONTEXT_PARAM_PATTERN.matcher(fullPath);
        if (pathParamMatcher.find()) {
            builder.append(fullPath, 0, pathParamMatcher.start()).append("*");
        } else {
            builder.append(fullPath);
        }
        return builder.toString();
    }

    public String getLabel() {
        return this.label;
    }

    public SpringController getParent() {
        return this.parent;
    }

    public Set<String> getConsumesMediaTypes() {
        return this.consumesMediaTypes;
    }

    public Set<String> getProducesMediaTypes() {
        return this.producesMediaTypes;
    }

    public Set<RequestParameter> getRequestParameters() {
        return this.requestParameters;
    }

    public ResourceEntityParameter getEntityParameter() {
        return this.entityParameter;
    }

    public List<ResourceMethodMediaType> getApplicableMediaTypes() {
        ResourceMethodMediaType supportedType;
        String type;
        HashMap<String, ResourceMethodMediaType> applicableTypes = new HashMap<String, ResourceMethodMediaType>();
        for (String consumesMime : this.getConsumesMediaTypes()) {
            type = consumesMime.contains(";") ? consumesMime.substring(0, consumesMime.indexOf(59)) : consumesMime;
            supportedType = (ResourceMethodMediaType)applicableTypes.get(type);
            if (supportedType == null) {
                supportedType = new ResourceMethodMediaType();
                supportedType.setType(type);
                applicableTypes.put(type, supportedType);
            }
            supportedType.setConsumable(true);
        }
        for (String producesMime : this.getProducesMediaTypes()) {
            type = producesMime.contains(";") ? producesMime.substring(0, producesMime.indexOf(59)) : producesMime;
            supportedType = (ResourceMethodMediaType)applicableTypes.get(type);
            if (supportedType == null) {
                supportedType = new ResourceMethodMediaType();
                supportedType.setType(type);
                applicableTypes.put(type, supportedType);
            }
            supportedType.setProduceable(true);
        }
        return new ArrayList<ResourceMethodMediaType>(applicableTypes.values());
    }

    public ResourceRepresentationMetadata getRepresentationMetadata() {
        return this.representationMetadata;
    }

    public List<? extends ResponseCode> getStatusCodes() {
        return this.statusCodes;
    }

    public List<? extends ResponseCode> getWarnings() {
        return this.warnings;
    }

    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.metaData);
    }

    public void putMetaData(String name, Object data) {
        this.metaData.put(name, data);
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Set<Facet> getFacets() {
        return this.facets;
    }

    public Set<String> getSecurityRoles() {
        SpringController parent;
        TreeSet<String> roles = new TreeSet<String>();
        RolesAllowed rolesAllowed = (RolesAllowed)this.getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            Collections.addAll(roles, rolesAllowed.value());
        }
        if ((parent = this.getParent()) != null) {
            roles.addAll(parent.getSecurityRoles());
        }
        return roles;
    }
}

