/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.api.impl;

import com.webcohesion.enunciate.api.datatype.Syntax;
import com.webcohesion.enunciate.api.resources.Entity;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.modules.spring_web.api.impl.CustomMediaTypeDescriptor;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMapping;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceRepresentationMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;

public class ResponseEntityImpl
implements Entity {
    private RequestMapping requestMapping;
    private ResourceRepresentationMetadata responseMetadata;

    public ResponseEntityImpl(RequestMapping requestMapping, ResourceRepresentationMetadata responseMetadata) {
        this.requestMapping = requestMapping;
        this.responseMetadata = responseMetadata;
    }

    public String getDescription() {
        return this.responseMetadata.getDocValue();
    }

    public List<? extends MediaTypeDescriptor> getMediaTypes() {
        Set<String> produces = this.requestMapping.getProducesMediaTypes();
        ArrayList<MediaTypeDescriptor> mts = new ArrayList<MediaTypeDescriptor>(produces.size());
        for (String mt : produces) {
            boolean descriptorFound = false;
            DecoratedTypeMirror type = (DecoratedTypeMirror)this.responseMetadata.getDelegate();
            for (Syntax syntax : this.requestMapping.getContext().getContext().getApiRegistry().getSyntaxes()) {
                MediaTypeDescriptor descriptor = syntax.findMediaTypeDescriptor(mt, type);
                if (descriptor == null) continue;
                mts.add(descriptor);
                descriptorFound = true;
            }
            if (descriptorFound) continue;
            mts.add(new CustomMediaTypeDescriptor(mt));
        }
        return mts;
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return Collections.emptyMap();
    }
}

