/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.api.impl;

import com.webcohesion.enunciate.api.PathSummary;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.metadata.Label;
import com.webcohesion.enunciate.metadata.rs.ResourceLabel;
import com.webcohesion.enunciate.modules.spring_web.api.impl.PathSummaryImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.ResourceImpl;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMapping;
import com.webcohesion.enunciate.modules.spring_web.model.SpringController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;

public class ResourceClassResourceGroupImpl
implements ResourceGroup {
    private final SpringController controllerClass;
    private final List<Resource> resources = new ArrayList<Resource>();
    private final String contextPath;

    public ResourceClassResourceGroupImpl(SpringController controllerClass, String contextPath) {
        this.controllerClass = controllerClass;
        this.contextPath = contextPath;
        FacetFilter facetFilter = controllerClass.getContext().getContext().getConfiguration().getFacetFilter();
        for (RequestMapping requestMapping : controllerClass.getRequestMappings()) {
            if (!facetFilter.accept((HasFacets)requestMapping)) continue;
            this.resources.add(new ResourceImpl(requestMapping, this));
        }
    }

    public String getSlug() {
        return "resource_" + this.controllerClass.getSimpleName().toString();
    }

    public String getLabel() {
        Label generic;
        String label = this.controllerClass.getSimpleName().toString();
        ResourceLabel resourceLabel = (ResourceLabel)this.controllerClass.getAnnotation(ResourceLabel.class);
        if (resourceLabel != null && !"##default".equals(resourceLabel.value())) {
            label = resourceLabel.value();
        }
        if ((generic = (Label)this.controllerClass.getAnnotation(Label.class)) != null) {
            label = generic.value();
        }
        return label;
    }

    public String getSortKey() {
        String sortKey = this.getLabel();
        ResourceLabel resourceLabel = (ResourceLabel)this.controllerClass.getAnnotation(ResourceLabel.class);
        if (resourceLabel != null && !"##default".equals(resourceLabel.sortKey())) {
            sortKey = resourceLabel.sortKey();
        }
        return sortKey;
    }

    public String getRelativeContextPath() {
        return this.contextPath;
    }

    public String getDescription() {
        return this.controllerClass.getJavaDoc().toString();
    }

    public String getDeprecated() {
        return ElementUtils.findDeprecationMessage((DecoratedElement)this.controllerClass);
    }

    public List<PathSummary> getPaths() {
        HashMap<String, PathSummary> summaries = new HashMap<String, PathSummary>();
        for (Resource resource : this.resources) {
            TreeSet<String> methods = new TreeSet<String>();
            for (Method method : resource.getMethods()) {
                methods.add(method.getHttpMethod());
            }
            PathSummary summary = (PathSummary)summaries.get(resource.getPath());
            if (summary == null) {
                summary = new PathSummaryImpl(resource.getPath(), methods);
                summaries.put(resource.getPath(), summary);
                continue;
            }
            summary.getMethods().addAll(methods);
        }
        return new ArrayList<PathSummary>(summaries.values());
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.controllerClass.getAnnotations();
    }
}

