/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.api.impl;

import com.webcohesion.enunciate.api.PathSummary;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.modules.spring_web.api.impl.PathSummaryImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;

public class PathBasedResourceGroupImpl
implements ResourceGroup {
    private final String contextPath;
    private final String path;
    private final List<Resource> resources;

    public PathBasedResourceGroupImpl(String contextPath, String path, List<Resource> resources) {
        this.contextPath = contextPath;
        this.path = path;
        this.resources = resources;
    }

    public String getSlug() {
        return "resource_" + PathBasedResourceGroupImpl.scrubPathForSlug(this.path);
    }

    public String getRelativeContextPath() {
        return this.contextPath;
    }

    public String getLabel() {
        return this.path;
    }

    public String getSortKey() {
        return this.path;
    }

    public String getDescription() {
        String description = null;
        for (Resource resource : this.resources) {
            for (Method method : resource.getMethods()) {
                if (description != null && method.getDescription() != null && !description.equals(method.getDescription())) {
                    return null;
                }
                description = method.getDescription();
            }
        }
        return description;
    }

    public String getDeprecated() {
        String deprecated = null;
        for (Resource resource : this.resources) {
            deprecated = resource.getDeprecated();
            if (deprecated != null) continue;
            return null;
        }
        return deprecated;
    }

    public List<PathSummary> getPaths() {
        TreeSet<String> methods = new TreeSet<String>();
        for (Resource resource : this.resources) {
            for (Method method : resource.getMethods()) {
                methods.add(method.getHttpMethod());
            }
        }
        return Arrays.asList(new PathSummaryImpl(this.path, methods));
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    private static String scrubPathForSlug(String facetValue) {
        return facetValue.replace('/', '_').replace(':', '_').replace('{', '_').replace('}', '_');
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return Collections.emptyMap();
    }
}

