/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.api.impl;

import com.webcohesion.enunciate.api.resources.Parameter;
import com.webcohesion.enunciate.modules.spring_web.model.RequestParameter;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceParameterConstraints;
import java.util.Iterator;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;

public class ParameterImpl
implements Parameter {
    private final RequestParameter param;

    public ParameterImpl(RequestParameter param) {
        this.param = param;
    }

    public String getName() {
        return this.param.getParameterName();
    }

    public String getDescription() {
        return this.param.getJavaDoc().toString();
    }

    public String getTypeLabel() {
        return this.param.getTypeName();
    }

    public String getDefaultValue() {
        return this.param.getDefaultValue();
    }

    public String getConstraints() {
        ResourceParameterConstraints constraints = this.param.getConstraints();
        if (constraints != null && constraints.getType() != null) {
            switch (constraints.getType()) {
                case UNBOUND_STRING: {
                    return null;
                }
                case ENUMERATION: {
                    StringBuilder builder = new StringBuilder();
                    Iterator<String> it = ((ResourceParameterConstraints.Enumeration)constraints).getValues().iterator();
                    while (it.hasNext()) {
                        String next = it.next();
                        builder.append('\"').append(next).append('\"');
                        if (!it.hasNext()) continue;
                        builder.append(" or ");
                    }
                    return builder.toString();
                }
                case PRIMITIVE: {
                    return ((ResourceParameterConstraints.Primitive)constraints).getKind().name().toLowerCase();
                }
                case REGEX: {
                    return "regex: " + ((ResourceParameterConstraints.Regex)constraints).getRegex();
                }
            }
        }
        return null;
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.param.getAnnotations();
    }
}

