/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.api.impl;

import com.webcohesion.enunciate.api.PathSummary;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.modules.spring_web.api.impl.PathSummaryImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;

public class AnnotationBasedResourceGroupImpl
implements ResourceGroup {
    private final String contextPath;
    private final String label;
    private final List<Resource> resources;

    public AnnotationBasedResourceGroupImpl(String contextPath, String label, List<Resource> resources) {
        this.contextPath = contextPath;
        this.label = label;
        this.resources = resources;
    }

    public String getSlug() {
        return "resource_" + AnnotationBasedResourceGroupImpl.scrubPathForSlug(this.label);
    }

    public String getRelativeContextPath() {
        return this.contextPath;
    }

    public String getLabel() {
        return this.label;
    }

    public String getSortKey() {
        return this.label;
    }

    public String getDescription() {
        String description = null;
        for (Resource resource : this.resources) {
            for (Method method : resource.getMethods()) {
                if (description != null && method.getDescription() != null && !description.equals(method.getDescription())) {
                    return null;
                }
                description = method.getDescription();
            }
        }
        return description;
    }

    public String getDeprecated() {
        String deprecated = null;
        for (Resource resource : this.resources) {
            deprecated = resource.getDeprecated();
            if (deprecated != null) continue;
            return null;
        }
        return deprecated;
    }

    public List<PathSummary> getPaths() {
        HashMap<String, PathSummary> paths = new HashMap<String, PathSummary>();
        for (Resource resource : this.resources) {
            PathSummary pathSummary = (PathSummary)paths.get(resource.getPath());
            if (pathSummary == null) {
                pathSummary = new PathSummaryImpl(resource.getPath(), new TreeSet<String>());
                paths.put(resource.getPath(), pathSummary);
            }
            for (Method method : resource.getMethods()) {
                pathSummary.getMethods().add(method.getHttpMethod());
            }
        }
        return new ArrayList<PathSummary>(paths.values());
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    private static String scrubPathForSlug(String facetValue) {
        return facetValue.replace('/', '_').replace(':', '_').replace('{', '_').replace('}', '_');
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return Collections.emptyMap();
    }
}

