/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.ApiRegistry;
import com.webcohesion.enunciate.module.ApiFeatureProviderModule;
import com.webcohesion.enunciate.module.ApiRegistryProviderModule;
import com.webcohesion.enunciate.module.BasicEnunicateModule;
import com.webcohesion.enunciate.module.DependencySpec;
import com.webcohesion.enunciate.module.EnunciateModule;
import com.webcohesion.enunciate.module.MediaTypeDefinitionModule;
import com.webcohesion.enunciate.module.TypeFilteringModule;
import com.webcohesion.enunciate.modules.spring_web.EnunciateSpringWebContext;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMapping;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceEntityParameter;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceRepresentationMetadata;
import com.webcohesion.enunciate.modules.spring_web.model.SpringController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.reflections.adapters.MetadataAdapter;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;

public class SpringWebModule
extends BasicEnunicateModule
implements TypeFilteringModule,
ApiRegistryProviderModule,
ApiFeatureProviderModule {
    private ApiRegistryProviderModule.DataTypeDetectionStrategy defaultDataTypeDetectionStrategy;
    private final List<MediaTypeDefinitionModule> mediaTypeModules = new ArrayList<MediaTypeDefinitionModule>();
    private ApiRegistry apiRegistry;
    private EnunciateSpringWebContext springContext;
    static final String NAME = "spring-web";

    public String getName() {
        return NAME;
    }

    public List<DependencySpec> getDependencySpecifications() {
        return Arrays.asList(new MediaTypeDependencySpec());
    }

    public ApiRegistryProviderModule.DataTypeDetectionStrategy getDataTypeDetectionStrategy() {
        String dataTypeDetection = this.config.getString("[@datatype-detection]", null);
        if (dataTypeDetection != null) {
            try {
                return ApiRegistryProviderModule.DataTypeDetectionStrategy.valueOf((String)dataTypeDetection);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.defaultDataTypeDetectionStrategy != null) {
            return this.defaultDataTypeDetectionStrategy;
        }
        if (this.enunciate.getIncludePatterns().isEmpty()) {
            return ApiRegistryProviderModule.DataTypeDetectionStrategy.local;
        }
        return ApiRegistryProviderModule.DataTypeDetectionStrategy.aggressive;
    }

    public void setDefaultDataTypeDetectionStrategy(ApiRegistryProviderModule.DataTypeDetectionStrategy strategy) {
        this.defaultDataTypeDetectionStrategy = strategy;
    }

    public void setApiRegistry(ApiRegistry registry) {
        this.apiRegistry = registry;
    }

    public EnunciateSpringWebContext getSpringWebContext() {
        return this.springContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(EnunciateContext context) {
        this.springContext = new EnunciateSpringWebContext(context);
        ApiRegistryProviderModule.DataTypeDetectionStrategy detectionStrategy = this.getDataTypeDetectionStrategy();
        if (detectionStrategy != ApiRegistryProviderModule.DataTypeDetectionStrategy.passive) {
            Set elements = detectionStrategy == ApiRegistryProviderModule.DataTypeDetectionStrategy.local ? context.getLocalApiElements() : context.getApiElements();
            for (Element declaration : elements) {
                if (!(declaration instanceof TypeElement)) continue;
                TypeElement element = (TypeElement)declaration;
                Controller controllerInfo = declaration.getAnnotation(Controller.class);
                RestController restControllerInfo = declaration.getAnnotation(RestController.class);
                if (controllerInfo == null && restControllerInfo == null) continue;
                SpringController springController = new SpringController(element, this.springContext);
                LinkedList<Element> contextStack = new LinkedList<Element>();
                contextStack.push((Element)((Object)springController));
                try {
                    List<RequestMapping> requestMappings = springController.getRequestMappings();
                    if (requestMappings.isEmpty()) continue;
                    this.springContext.add(springController);
                    for (RequestMapping requestMapping : requestMappings) {
                        this.addReferencedDataTypeDefinitions(requestMapping, contextStack);
                    }
                }
                finally {
                    contextStack.pop();
                }
            }
        }
        String relativeContextPath = this.config.getString("application[@path]", "");
        while (relativeContextPath.startsWith("/")) {
            relativeContextPath = relativeContextPath.substring(1);
        }
        while (relativeContextPath.endsWith("/")) {
            relativeContextPath = relativeContextPath.substring(0, relativeContextPath.length() - 1);
        }
        this.springContext.setRelativeContextPath(relativeContextPath);
        this.springContext.setGroupingStrategy(this.getGroupingStrategy());
        if (!this.springContext.getControllers().isEmpty()) {
            this.apiRegistry.getResourceApis().add(this.springContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReferencedDataTypeDefinitions(RequestMapping requestMapping, LinkedList<Element> contextStack) {
        ResourceRepresentationMetadata outputPayload;
        TypeMirror type;
        ResourceEntityParameter ep = requestMapping.getEntityParameter();
        if (ep != null) {
            Set<String> consumes = requestMapping.getConsumesMediaTypes();
            contextStack.push(ep.getDelegate());
            type = ep.getType();
            contextStack.push((Element)((Object)requestMapping));
            try {
                for (MediaTypeDefinitionModule mediaTypeModule : this.mediaTypeModules) {
                    mediaTypeModule.addDataTypeDefinitions(type, consumes, contextStack);
                }
            }
            finally {
                contextStack.pop();
            }
        }
        if ((outputPayload = requestMapping.getRepresentationMetadata()) != null) {
            type = outputPayload.getDelegate();
            Set<String> produces = requestMapping.getProducesMediaTypes();
            contextStack.push((Element)((Object)requestMapping));
            try {
                for (MediaTypeDefinitionModule mediaTypeModule : this.mediaTypeModules) {
                    mediaTypeModule.addDataTypeDefinitions(type, produces, contextStack);
                }
            }
            finally {
                contextStack.pop();
            }
        }
    }

    public EnunciateSpringWebContext.GroupingStrategy getGroupingStrategy() {
        String groupBy = this.config.getString("[@groupBy]", "class");
        if ("class".equals(groupBy)) {
            return EnunciateSpringWebContext.GroupingStrategy.resource_class;
        }
        if ("path".equals(groupBy)) {
            return EnunciateSpringWebContext.GroupingStrategy.path;
        }
        if ("annotation".equals(groupBy)) {
            return EnunciateSpringWebContext.GroupingStrategy.annotation;
        }
        throw new EnunciateException("Unknown grouping strategy: " + groupBy);
    }

    public boolean acceptType(Object type, MetadataAdapter metadata) {
        List classAnnotations = metadata.getClassAnnotationNames(type);
        if (classAnnotations != null) {
            for (String classAnnotation : classAnnotations) {
                if (!Controller.class.getName().equals(classAnnotation) && !RestController.class.getName().equals(classAnnotation)) continue;
                return true;
            }
        }
        return false;
    }

    public class MediaTypeDependencySpec
    implements DependencySpec {
        public boolean accept(EnunciateModule module) {
            if (module instanceof MediaTypeDefinitionModule) {
                MediaTypeDefinitionModule definitionModule = (MediaTypeDefinitionModule)module;
                SpringWebModule.this.mediaTypeModules.add(definitionModule);
                definitionModule.setDefaultDataTypeDetectionStrategy(ApiRegistryProviderModule.DataTypeDetectionStrategy.passive);
                return true;
            }
            return false;
        }

        public boolean isFulfilled() {
            return true;
        }

        public String toString() {
            return "media type definition modules";
        }
    }
}

