/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.api.InterfaceDescriptionFile;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceApi;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.TypeElementComparator;
import com.webcohesion.enunciate.module.EnunciateModuleContext;
import com.webcohesion.enunciate.modules.spring_web.api.impl.AnnotationBasedResourceGroupImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.PathBasedResourceGroupImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.ResourceClassResourceGroupImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.ResourceImpl;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMapping;
import com.webcohesion.enunciate.modules.spring_web.model.SpringController;
import com.webcohesion.enunciate.util.ResourceGroupComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class EnunciateSpringWebContext
extends EnunciateModuleContext
implements ResourceApi {
    private final Set<SpringController> controllers;
    private String relativeContextPath = "";
    private GroupingStrategy groupingStrategy = GroupingStrategy.resource_class;
    private InterfaceDescriptionFile wadlFile = null;

    public EnunciateSpringWebContext(EnunciateContext context) {
        super(context);
        this.controllers = new TreeSet<SpringController>((Comparator<SpringController>)new TypeElementComparator());
    }

    public EnunciateContext getContext() {
        return this.context;
    }

    public Set<SpringController> getControllers() {
        return this.controllers;
    }

    public void add(SpringController controller) {
        this.controllers.add(controller);
        this.debug("Added %s as a Spring controller.", new Object[]{controller.getQualifiedName()});
    }

    public boolean isIncludeResourceGroupName() {
        return this.groupingStrategy != GroupingStrategy.path;
    }

    public void setRelativeContextPath(String relativeContextPath) {
        this.relativeContextPath = relativeContextPath;
    }

    public void setGroupingStrategy(GroupingStrategy groupingStrategy) {
        this.groupingStrategy = groupingStrategy;
    }

    public InterfaceDescriptionFile getWadlFile() {
        return this.wadlFile;
    }

    public void setWadlFile(InterfaceDescriptionFile wadlFile) {
        this.wadlFile = wadlFile;
    }

    public List<ResourceGroup> getResourceGroups() {
        List<ResourceGroup> resourceGroups = this.groupingStrategy == GroupingStrategy.path ? this.getResourceGroupsByPath() : (this.groupingStrategy == GroupingStrategy.annotation ? this.getResourceGroupsByAnnotation() : this.getResourceGroupsByClass());
        Collections.sort(resourceGroups, new Comparator<ResourceGroup>(){

            @Override
            public int compare(ResourceGroup o1, ResourceGroup o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        });
        return resourceGroups;
    }

    public List<ResourceGroup> getResourceGroupsByClass() {
        ArrayList<ResourceGroup> resourceGroups = new ArrayList<ResourceGroup>();
        for (SpringController springController : this.controllers) {
            ResourceClassResourceGroupImpl group = new ResourceClassResourceGroupImpl(springController, this.relativeContextPath);
            if (group.getResources().isEmpty()) continue;
            resourceGroups.add(group);
        }
        Collections.sort(resourceGroups, new ResourceGroupComparator());
        return resourceGroups;
    }

    public List<ResourceGroup> getResourceGroupsByPath() {
        HashMap<String, PathBasedResourceGroupImpl> resourcesByPath = new HashMap<String, PathBasedResourceGroupImpl>();
        FacetFilter facetFilter = this.context.getConfiguration().getFacetFilter();
        for (SpringController springController : this.controllers) {
            for (RequestMapping method : springController.getRequestMappings()) {
                if (!facetFilter.accept((HasFacets)method)) continue;
                String path = method.getFullpath();
                PathBasedResourceGroupImpl resourceGroup = (PathBasedResourceGroupImpl)resourcesByPath.get(path);
                if (resourceGroup == null) {
                    resourceGroup = new PathBasedResourceGroupImpl(this.relativeContextPath, path, new ArrayList<Resource>());
                    resourcesByPath.put(path, resourceGroup);
                }
                resourceGroup.getResources().add(new ResourceImpl(method, resourceGroup));
            }
        }
        ArrayList<ResourceGroup> resourceGroups = new ArrayList<ResourceGroup>(resourcesByPath.values());
        Collections.sort(resourceGroups, new ResourceGroupComparator());
        return resourceGroups;
    }

    public List<ResourceGroup> getResourceGroupsByAnnotation() {
        HashMap<String, AnnotationBasedResourceGroupImpl> resourcesByAnnotation = new HashMap<String, AnnotationBasedResourceGroupImpl>();
        FacetFilter facetFilter = this.context.getConfiguration().getFacetFilter();
        for (SpringController springController : this.controllers) {
            for (RequestMapping method : springController.getRequestMappings()) {
                if (!facetFilter.accept((HasFacets)method)) continue;
                com.webcohesion.enunciate.metadata.rs.ResourceGroup annotation = (com.webcohesion.enunciate.metadata.rs.ResourceGroup)method.getAnnotation(com.webcohesion.enunciate.metadata.rs.ResourceGroup.class);
                String label = annotation == null ? "Other" : annotation.value();
                AnnotationBasedResourceGroupImpl resourceGroup = (AnnotationBasedResourceGroupImpl)resourcesByAnnotation.get(label);
                if (resourceGroup == null) {
                    resourceGroup = new AnnotationBasedResourceGroupImpl(this.relativeContextPath, label, new ArrayList<Resource>());
                    resourcesByAnnotation.put(label, resourceGroup);
                }
                resourceGroup.getResources().add(new ResourceImpl(method, resourceGroup));
            }
        }
        ArrayList<ResourceGroup> resourceGroups = new ArrayList<ResourceGroup>(resourcesByAnnotation.values());
        Collections.sort(resourceGroups, new ResourceGroupComparator());
        return resourceGroups;
    }

    public static enum GroupingStrategy {
        path,
        annotation,
        resource_class;

    }
}

