/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.objc_client;

import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.metadata.ClientName;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.Accessor;
import com.webcohesion.enunciate.modules.jaxb.model.adapters.Adaptable;
import com.webcohesion.enunciate.modules.jaxb.model.adapters.AdapterType;
import com.webcohesion.enunciate.modules.jaxb.model.util.JAXBUtil;
import com.webcohesion.enunciate.util.HasClientConvertibleType;
import freemarker.template.TemplateModelException;
import java.awt.Image;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;

public class ClientClassnameForMethod
extends com.webcohesion.enunciate.util.freemarker.ClientClassnameForMethod {
    private final Map<String, String> classConversions = new HashMap<String, String>();
    private final EnunciateJaxbContext jaxbContext;

    public ClientClassnameForMethod(Map<String, String> conversions, EnunciateJaxbContext jaxbContext) {
        super(conversions, jaxbContext.getContext());
        this.jaxbContext = jaxbContext;
        this.classConversions.put(Boolean.class.getName(), "BOOL");
        this.classConversions.put(String.class.getName(), "NSString");
        this.classConversions.put(Integer.class.getName(), "int");
        this.classConversions.put(Short.class.getName(), "short");
        this.classConversions.put(Byte.class.getName(), "unsigned char");
        this.classConversions.put(Double.class.getName(), "double");
        this.classConversions.put(Long.class.getName(), "long long");
        this.classConversions.put(BigInteger.class.getName(), "NSNumber");
        this.classConversions.put(BigDecimal.class.getName(), "NSDecimalNumber");
        this.classConversions.put(Float.class.getName(), "float");
        this.classConversions.put(Character.class.getName(), "unsigned short");
        this.classConversions.put(Date.class.getName(), "NSDate");
        this.classConversions.put(Timestamp.class.getName(), "NSDate");
        this.classConversions.put(DataHandler.class.getName(), "NSData");
        this.classConversions.put(Image.class.getName(), "NSData");
        this.classConversions.put(Source.class.getName(), "NSData");
        this.classConversions.put(QName.class.getName(), "QName");
        this.classConversions.put(URI.class.getName(), "NSURL");
        this.classConversions.put(UUID.class.getName(), "NSString");
        this.classConversions.put(XMLGregorianCalendar.class.getName(), "NSCalendarDate");
        this.classConversions.put(GregorianCalendar.class.getName(), "NSCalendarDate");
        this.classConversions.put(Calendar.class.getName(), "NSCalendarDate");
        this.classConversions.put(Duration.class.getName(), "NSString");
        this.classConversions.put(JAXBElement.class.getName(), "JAXBBasicXMLNode");
        this.classConversions.put(Object.class.getName(), "NSObject");
        this.classConversions.putAll(conversions);
    }

    public String convert(TypeElement declaration) throws TemplateModelException {
        DecoratedTypeMirror superType;
        String fqn = declaration.getQualifiedName().toString();
        if (this.classConversions.containsKey(fqn)) {
            return this.classConversions.get(fqn);
        }
        if (ElementUtils.isCollection((TypeElement)declaration)) {
            return "NSArray";
        }
        AdapterType adapterType = JAXBUtil.findAdapterType((Element)declaration, (EnunciateJaxbContext)this.jaxbContext);
        if (adapterType != null) {
            return this.convert(adapterType.getAdaptingType());
        }
        if (declaration.getKind() == ElementKind.CLASS && (superType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)declaration.getSuperclass(), (DecoratedProcessingEnvironment)this.context.getProcessingEnvironment())) != null && superType.isInstanceOf(JAXBElement.class.getName())) {
            return this.convert((TypeMirror)superType);
        }
        String convertedPackage = this.convertPackage(this.context.getProcessingEnvironment().getElementUtils().getPackageOf(declaration));
        ClientName specifiedName = declaration.getAnnotation(ClientName.class);
        String simpleName = specifiedName == null ? declaration.getSimpleName().toString() : specifiedName.value();
        return convertedPackage + this.getPackageSeparator() + simpleName;
    }

    public String convert(HasClientConvertibleType element) throws TemplateModelException {
        if (element instanceof Accessor) {
            Accessor accessor = (Accessor)element;
            if (accessor.isXmlList()) {
                return "NSString";
            }
            if (accessor.isXmlIDREF() && !accessor.isCollectionType()) {
                return "NSString";
            }
        }
        if (element instanceof Adaptable && ((Adaptable)element).isAdapted()) {
            return this.convert(((Adaptable)element).getAdapterType().getAdaptingType((DecoratedTypeMirror)element.getClientConvertibleType(), this.context));
        }
        return super.convert(element);
    }

    public String convert(TypeMirror typeMirror) throws TemplateModelException {
        DecoratedTypeMirror decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)typeMirror, (DecoratedProcessingEnvironment)this.context.getProcessingEnvironment());
        if (decorated.isPrimitive()) {
            TypeKind kind = decorated.getKind();
            switch (kind) {
                case BOOLEAN: {
                    return "BOOL";
                }
                case BYTE: {
                    return "unsigned char";
                }
                case INT: {
                    return "int";
                }
                case SHORT: {
                    return "short";
                }
                case FLOAT: {
                    return "float";
                }
                case DOUBLE: {
                    return "double";
                }
                case LONG: {
                    return "long long";
                }
                case CHAR: {
                    return "unsigned short";
                }
            }
            return "NSString";
        }
        if (decorated.isCollection()) {
            return "NSArray";
        }
        if (decorated.isWildcard()) {
            WildcardType wildcardType = (WildcardType)decorated;
            return this.convert(wildcardType.getExtendsBound());
        }
        if (decorated.isArray()) {
            TypeMirror componentType = ((ArrayType)decorated).getComponentType();
            if (componentType instanceof PrimitiveType && componentType.getKind() == TypeKind.BYTE) {
                return "NSData";
            }
            return "NSArray";
        }
        return super.convert(typeMirror);
    }

    public String convertDeclaredTypeArguments(List<? extends TypeMirror> actualTypeArguments) throws TemplateModelException {
        return "";
    }

    public String convert(TypeVariable typeVariable) throws TemplateModelException {
        String conversion = "NSObject";
        if (typeVariable.getUpperBound() != null) {
            conversion = this.convert(typeVariable.getUpperBound());
        }
        return conversion;
    }
}

