/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.csharp_client;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.DefaultRegistrationContext;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.artifacts.Artifact;
import com.webcohesion.enunciate.artifacts.ArtifactType;
import com.webcohesion.enunciate.artifacts.ClientLibraryArtifact;
import com.webcohesion.enunciate.artifacts.FileArtifact;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.metadata.ClientName;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import com.webcohesion.enunciate.module.ApiFeatureProviderModule;
import com.webcohesion.enunciate.module.ApiRegistryProviderModule;
import com.webcohesion.enunciate.module.BasicGeneratingModule;
import com.webcohesion.enunciate.module.DependencySpec;
import com.webcohesion.enunciate.module.EnunciateModule;
import com.webcohesion.enunciate.modules.csharp_client.CSharpXMLClientObjectWrapper;
import com.webcohesion.enunciate.modules.csharp_client.ClientClassnameForMethod;
import com.webcohesion.enunciate.modules.csharp_client.ListsAsArraysClientClassnameForMethod;
import com.webcohesion.enunciate.modules.csharp_client.RequestDocumentQNameMethod;
import com.webcohesion.enunciate.modules.csharp_client.ResponseDocumentQNameMethod;
import com.webcohesion.enunciate.modules.csharp_client.SimpleNameFor;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.JaxbModule;
import com.webcohesion.enunciate.modules.jaxb.model.Attribute;
import com.webcohesion.enunciate.modules.jaxb.model.Element;
import com.webcohesion.enunciate.modules.jaxb.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.SchemaInfo;
import com.webcohesion.enunciate.modules.jaxb.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.util.JAXBCodeErrors;
import com.webcohesion.enunciate.modules.jaxb.model.util.MapType;
import com.webcohesion.enunciate.modules.jaxb.util.AccessorOverridesAnotherMethod;
import com.webcohesion.enunciate.modules.jaxb.util.FindRootElementMethod;
import com.webcohesion.enunciate.modules.jaxrs.JaxrsModule;
import com.webcohesion.enunciate.modules.jaxws.JaxwsModule;
import com.webcohesion.enunciate.modules.jaxws.WsdlInfo;
import com.webcohesion.enunciate.modules.jaxws.model.EndpointInterface;
import com.webcohesion.enunciate.modules.jaxws.model.WebFault;
import com.webcohesion.enunciate.modules.jaxws.model.WebMethod;
import com.webcohesion.enunciate.modules.jaxws.model.WebParam;
import com.webcohesion.enunciate.util.freemarker.ClientPackageForMethod;
import com.webcohesion.enunciate.util.freemarker.FileDirective;
import com.webcohesion.enunciate.util.freemarker.IsFacetExcludedMethod;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.jws.WebParam;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import org.apache.commons.configuration.HierarchicalConfiguration;

public class CSharpXMLClientModule
extends BasicGeneratingModule
implements ApiFeatureProviderModule {
    private static final String LIRBARY_DESCRIPTION_PROPERTY = "com.webcohesion.enunciate.modules.csharp_client.CSharpXMLClientModule#LIRBARY_DESCRIPTION_PROPERTY";
    JaxbModule jaxbModule;
    JaxwsModule jaxwsModule;
    JaxrsModule jaxrsModule;

    public String getName() {
        return "csharp-xml-client";
    }

    public List<DependencySpec> getDependencySpecifications() {
        return Arrays.asList(new DependencySpec(){

            public boolean accept(EnunciateModule module) {
                if (module instanceof JaxbModule) {
                    CSharpXMLClientModule.this.jaxbModule = (JaxbModule)module;
                    return true;
                }
                if (module instanceof JaxwsModule) {
                    CSharpXMLClientModule.this.jaxwsModule = (JaxwsModule)module;
                    return true;
                }
                if (module instanceof JaxrsModule) {
                    CSharpXMLClientModule.this.jaxrsModule = (JaxrsModule)module;
                    return true;
                }
                return module instanceof ApiRegistryProviderModule;
            }

            public boolean isFulfilled() {
                return true;
            }

            public String toString() {
                return "optional jaxb, optional jaxws, optional jaxrs";
            }
        });
    }

    public void call(EnunciateContext context) {
        if (this.jaxbModule == null || this.jaxbModule.getJaxbContext() == null || this.jaxbModule.getJaxbContext().getSchemas().isEmpty()) {
            this.info("No JAXB XML data types: C# XML client will not be generated.", new Object[0]);
            return;
        }
        if (this.usesUnmappableElements()) {
            this.warn("Web service API makes use of elements that cannot be handled by the C# XML client. C# XML client will not be generated.", new Object[0]);
            return;
        }
        List namingConflicts = JAXBCodeErrors.findConflictingAccessorNamingErrors((EnunciateJaxbContext)this.jaxbModule.getJaxbContext());
        if (namingConflicts != null && !namingConflicts.isEmpty()) {
            this.error("JAXB naming conflicts have been found:", new Object[0]);
            for (String namingConflict : namingConflicts) {
                this.error(namingConflict, new Object[0]);
            }
            this.error("These naming conflicts are often between the field and it's associated property, in which case you need to use one or two of the following strategies to avoid the conflicts:", new Object[0]);
            this.error("1. Explicitly exclude one or the other.", new Object[0]);
            this.error("2. Put the annotations on the property instead of the field.", new Object[0]);
            this.error("3. Tell JAXB to use a different process for detecting accessors using the @XmlAccessorType annotation.", new Object[0]);
            throw new EnunciateException("JAXB naming conflicts detected.");
        }
        Map<String, String> packageToNamespaceConversions = this.buildPackageToNamespaceConversions();
        File srcDir = this.generateSources(packageToNamespaceConversions);
        File compileDir = this.compileSources(srcDir);
        this.packageArtifacts(srcDir, compileDir);
    }

    private Map<String, String> buildPackageToNamespaceConversions() {
        Map<String, String> packageToNamespaceConversions = this.getPackageToNamespaceConversions();
        if (this.jaxwsModule != null) {
            HashMap<String, WebFault> allFaults = new HashMap<String, WebFault>();
            for (WsdlInfo wsdlInfo : this.jaxwsModule.getJaxwsContext().getWsdls().values()) {
                for (EndpointInterface ei : wsdlInfo.getEndpointInterfaces()) {
                    String pckg = ei.getPackage().getQualifiedName().toString();
                    if (!packageToNamespaceConversions.containsKey(pckg)) {
                        packageToNamespaceConversions.put(pckg, this.packageToNamespace(pckg));
                    }
                    for (WebMethod webMethod : ei.getWebMethods()) {
                        for (WebFault webFault : webMethod.getWebFaults()) {
                            allFaults.put(webFault.getQualifiedName().toString(), webFault);
                        }
                    }
                }
            }
            for (WebFault webFault : allFaults.values()) {
                String pckg = webFault.getPackage().getQualifiedName().toString();
                if (packageToNamespaceConversions.containsKey(pckg)) continue;
                packageToNamespaceConversions.put(pckg, this.packageToNamespace(pckg));
            }
        }
        if (this.jaxbModule != null) {
            for (SchemaInfo schemaInfo : this.jaxbModule.getJaxbContext().getSchemas().values()) {
                for (TypeDefinition typeDefinition : schemaInfo.getTypeDefinitions()) {
                    String pckg = typeDefinition.getPackage().getQualifiedName().toString();
                    if (packageToNamespaceConversions.containsKey(pckg)) continue;
                    packageToNamespaceConversions.put(pckg, this.packageToNamespace(pckg));
                }
            }
        }
        return packageToNamespaceConversions;
    }

    protected boolean usesUnmappableElements() {
        boolean usesUnmappableElements = false;
        if (this.jaxwsModule != null && this.jaxwsModule.getJaxwsContext() != null) {
            for (EndpointInterface ei : this.jaxwsModule.getJaxwsContext().getEndpointInterfaces()) {
                HashMap<String, Object> paramsByName = new HashMap<String, Object>();
                for (WebMethod webMethod : ei.getWebMethods()) {
                    javax.lang.model.element.Element conflict;
                    for (WebParam webParam : webMethod.getWebParameters()) {
                        if (webParam.isHeader()) {
                            DecoratedTypeMirror paramType;
                            javax.lang.model.element.Element conflict2 = (javax.lang.model.element.Element)paramsByName.put(webParam.getElementName(), webParam);
                            if (conflict2 != null) {
                                this.warn("%s: C# requires that all header parameters defined in the same endpoint interface have unique names. This parameter conflicts with the one at %s.", new Object[]{this.positionOf((javax.lang.model.element.Element)webParam), this.positionOf(conflict2)});
                                usesUnmappableElements = true;
                            }
                            if ((paramType = (DecoratedTypeMirror)webParam.getType()).isCollection()) {
                                this.warn("%s: C# can't handle header parameters that are collections.", new Object[]{this.positionOf((javax.lang.model.element.Element)webParam)});
                                usesUnmappableElements = true;
                            }
                        } else if (webParam.getMode() != WebParam.Mode.IN) {
                            this.warn("%s: C# doesn't support non-header parameters of mode %s.", new Object[]{this.positionOf((javax.lang.model.element.Element)webParam), webParam.getMode()});
                            usesUnmappableElements = true;
                        }
                        if (!(webParam.getType() instanceof MapType)) continue;
                        this.warn("%s: C# can't handle parameter types that are maps.", new Object[]{this.positionOf((javax.lang.model.element.Element)webParam)});
                        usesUnmappableElements = true;
                    }
                    if (webMethod.getWebResult().isHeader() && (conflict = (javax.lang.model.element.Element)paramsByName.put(webMethod.getWebResult().getElementName(), webMethod)) != null) {
                        this.warn("%s: C# requires that all header parameters defined in the same endpoint interface have unique names. This return parameter conflicts with the one at %s.", new Object[]{this.positionOf((javax.lang.model.element.Element)webMethod), this.positionOf(conflict)});
                        usesUnmappableElements = true;
                    }
                    if (webMethod.getWebResult().getType() instanceof MapType) {
                        this.warn("%s: C# can't handle return types that are maps.", new Object[]{this.positionOf((javax.lang.model.element.Element)webMethod)});
                        usesUnmappableElements = true;
                    }
                    if (!ElementUtils.capitalize((String)webMethod.getClientSimpleName()).equals(ei.getClientSimpleName())) continue;
                    this.warn("%s: C# can't handle methods that are of the same name as their containing class. Either rename the method, or use the @org.codehaus.enunciate.ClientName annotation to rename the method (or type) on the client-side.", new Object[]{this.positionOf((javax.lang.model.element.Element)webMethod)});
                    usesUnmappableElements = true;
                }
            }
        }
        if (this.jaxbModule != null && this.jaxbModule.getJaxbContext() != null && !this.jaxbModule.getJaxbContext().getSchemas().isEmpty()) {
            for (SchemaInfo schemaInfo : this.jaxbModule.getJaxbContext().getSchemas().values()) {
                for (TypeDefinition complexType : schemaInfo.getTypeDefinitions()) {
                    for (Attribute attribute : complexType.getAttributes()) {
                        if (!ElementUtils.capitalize((String)attribute.getClientSimpleName()).equals(complexType.getClientSimpleName())) continue;
                        this.warn("%s: C# can't handle properties/fields that are of the same name as their containing class. Either rename the property/field, or use the @com.webcohesion.enunciate.metadata.ClientName annotation to rename the property/field on the client-side.", new Object[]{this.positionOf((javax.lang.model.element.Element)attribute)});
                        usesUnmappableElements = true;
                    }
                    if (complexType.getValue() != null && ElementUtils.capitalize((String)complexType.getValue().getClientSimpleName()).equals(complexType.getClientSimpleName())) {
                        this.warn("%s: C# can't handle properties/fields that are of the same name as their containing class. Either rename the property/field, or use the @com.webcohesion.enunciate.metadata.ClientName annotation to rename the property/field on the client-side.", new Object[]{this.positionOf((javax.lang.model.element.Element)complexType.getValue())});
                        usesUnmappableElements = true;
                    }
                    for (Element element : complexType.getElements()) {
                        if (ElementUtils.capitalize((String)element.getClientSimpleName()).equals(complexType.getClientSimpleName())) {
                            this.warn("%s: C# can't handle properties/fields that are of the same name as their containing class. Either rename the property/field, or use the @com.webcohesion.enunciate.metadata.ClientName annotation to rename the property/field on the client-side.", new Object[]{this.positionOf((javax.lang.model.element.Element)element)});
                            usesUnmappableElements = true;
                        }
                        if (!(element.getAccessorType() instanceof MapType) || element.isAdapted()) continue;
                        this.warn("%s: The C# client doesn't have a built-in way of serializing a Map. Use @XmlJavaTypeAdapter to supply your own adapter for the Map.", new Object[]{this.positionOf((javax.lang.model.element.Element)element)});
                        usesUnmappableElements = true;
                    }
                    if (complexType instanceof EnumTypeDefinition) {
                        List enums = complexType.enumValues();
                        for (VariableElement enumItem : enums) {
                            String simpleName = enumItem.getSimpleName().toString();
                            ClientName clientNameInfo = enumItem.getAnnotation(ClientName.class);
                            if (clientNameInfo != null) {
                                simpleName = clientNameInfo.value();
                            }
                            if ("event".equals(simpleName)) {
                                this.warn("%s: C# can't handle an enum constant named 'Event'. Either rename the enum constant, or use the @com.webcohesion.enunciate.metadata.ClientName annotation to rename it on the client-side.", new Object[]{this.positionOf(enumItem)});
                                usesUnmappableElements = true;
                                continue;
                            }
                            if (!simpleName.equals(complexType.getClientSimpleName())) continue;
                            this.warn("C# can't handle properties/fields that are of the same name as their containing class. Either rename the property/field, or use the @com.webcohesion.enunciate.metadata.ClientName annotation to rename the property/field on the client-side.", new Object[]{this.positionOf(enumItem)});
                            usesUnmappableElements = true;
                        }
                    }
                    if (!ElementUtils.isMap((TypeElement)complexType)) continue;
                    this.warn("%s: C# client doesn't handles types that implement java.util.Map. Use @XmlJavaTypeAdapter to supply your own adapter for the Map.", new Object[]{this.positionOf((javax.lang.model.element.Element)complexType)});
                    usesUnmappableElements = true;
                }
            }
        }
        return usesUnmappableElements;
    }

    private File generateSources(Map<String, String> packageToNamespaceConversions) {
        File srcDir = this.getSourceDir();
        srcDir.mkdirs();
        HashMap<String, Object> model = new HashMap<String, Object>();
        ClientPackageForMethod namespaceFor = new ClientPackageForMethod(packageToNamespaceConversions, this.context);
        Collection<Object> wsdls = new ArrayList();
        if (this.jaxwsModule != null) {
            wsdls = this.jaxwsModule.getJaxwsContext().getWsdls().values();
        }
        model.put("wsdls", wsdls);
        EnunciateJaxbContext jaxbContext = this.jaxbModule.getJaxbContext();
        model.put("schemas", jaxbContext.getSchemas().values());
        model.put("baseUri", this.enunciate.getConfiguration().getApplicationRoot());
        model.put("generatedCodeLicense", this.enunciate.getConfiguration().readGeneratedCodeLicenseFile());
        model.put("namespaceFor", namespaceFor);
        model.put("findRootElement", new FindRootElementMethod(jaxbContext));
        model.put("requestDocumentQName", new RequestDocumentQNameMethod());
        model.put("responseDocumentQName", new ResponseDocumentQNameMethod());
        ClientClassnameForMethod classnameFor = new ClientClassnameForMethod(packageToNamespaceConversions, jaxbContext);
        model.put("classnameFor", (Object)classnameFor);
        model.put("listsAsArraysClassnameFor", (Object)new ListsAsArraysClientClassnameForMethod(packageToNamespaceConversions, jaxbContext));
        model.put("simpleNameFor", (Object)new SimpleNameFor(classnameFor));
        model.put("csFileName", this.getSourceFileName());
        model.put("accessorOverridesAnother", new AccessorOverridesAnotherMethod());
        model.put("file", new FileDirective(srcDir, this.enunciate.getLogger()));
        TreeSet<String> facetIncludes = new TreeSet<String>(this.enunciate.getConfiguration().getFacetIncludes());
        facetIncludes.addAll(this.getFacetIncludes());
        TreeSet<String> facetExcludes = new TreeSet<String>(this.enunciate.getConfiguration().getFacetExcludes());
        facetExcludes.addAll(this.getFacetExcludes());
        FacetFilter facetFilter = new FacetFilter(facetIncludes, facetExcludes);
        model.put("isFacetExcluded", new IsFacetExcludedMethod(facetFilter));
        if (!this.isUpToDateWithSources(srcDir)) {
            this.debug("Generating the C# client classes...", new Object[0]);
            URL apiTemplate = this.isSingleFilePerClass() ? this.getTemplateURL("api-multiple-files.fmt") : this.getTemplateURL("api.fmt");
            try {
                this.processTemplate(apiTemplate, model);
            }
            catch (IOException e) {
                throw new EnunciateException((Throwable)e);
            }
            catch (TemplateException e) {
                throw new EnunciateException((Throwable)e);
            }
        } else {
            this.info("Skipping C# code generation because everything appears up-to-date.", new Object[0]);
        }
        this.context.setProperty(LIRBARY_DESCRIPTION_PROPERTY, (Object)this.readLibraryDescription(model));
        return srcDir;
    }

    private File compileSources(File srcDir) {
        File compileDir = this.getCompileDir();
        compileDir.mkdirs();
        if (!this.isDisableCompile()) {
            if (!this.isUpToDateWithSources(compileDir)) {
                String compileCommand;
                String compileExectuable = this.getCompileExecutable();
                if (compileExectuable == null) {
                    int exitCode;
                    int len;
                    byte[] buffer;
                    InputStream in;
                    Process process;
                    String osName = System.getProperty("os.name");
                    if (osName != null && osName.toUpperCase().contains("WINDOWS")) {
                        this.debug("Attempting to execute command \"csc /help\" for the current environment (%s).", new Object[]{osName});
                        try {
                            process = new ProcessBuilder("csc", "/help").redirectErrorStream(true).start();
                            in = process.getInputStream();
                            buffer = new byte[1024];
                            len = in.read(buffer);
                            while (len > 0) {
                                len = in.read(buffer);
                            }
                            exitCode = process.waitFor();
                            if (exitCode != 0) {
                                this.debug("Command \"csc /help\" failed with exit code " + exitCode + ".", new Object[0]);
                            } else {
                                compileExectuable = "csc";
                                this.debug("C# compile executable to be used: csc", new Object[0]);
                            }
                        }
                        catch (Throwable e) {
                            this.debug("Command \"csc /help\" failed (" + e.getMessage() + ").", new Object[0]);
                        }
                    }
                    if (compileExectuable == null) {
                        this.debug("Attempting to execute command \"gmcs /help\" for the current environment (%s).", new Object[]{osName});
                        try {
                            process = new ProcessBuilder("gmcs", "/help").redirectErrorStream(true).start();
                            in = process.getInputStream();
                            buffer = new byte[1024];
                            len = in.read(buffer);
                            while (len > 0) {
                                len = in.read(buffer);
                            }
                            exitCode = process.waitFor();
                            if (exitCode != 0) {
                                this.debug("Command \"gmcs /help\" failed with exit code " + exitCode + ".", new Object[0]);
                            } else {
                                compileExectuable = "gmcs";
                                this.debug("C# compile executable to be used: %s", new Object[]{compileExectuable});
                            }
                        }
                        catch (Throwable e) {
                            this.debug("Command \"gmcs /help\" failed (" + e.getMessage() + ").", new Object[0]);
                        }
                    }
                    if (compileExectuable == null && this.isRequire()) {
                        throw new EnunciateException("C# client code generation is required, but there was no valid compile executable found. Please supply one in the configuration file, or set it up on your system path.");
                    }
                }
                if ((compileCommand = this.getCompileCommand()) == null) {
                    throw new IllegalStateException("Somehow the \"compile\" step was invoked on the C# module without a valid compile command.");
                }
                compileCommand = compileCommand.replace(' ', '\u0000');
                File dll = new File(compileDir, this.getDLLFileName());
                File docXml = new File(compileDir, this.getDocXmlFileName());
                File sourceFile = new File(srcDir, this.getSourceFileName());
                compileCommand = String.format(compileCommand, compileExectuable, dll.getAbsolutePath(), docXml.getAbsolutePath(), sourceFile.getAbsolutePath());
                StringTokenizer tokenizer = new StringTokenizer(compileCommand, "\u0000");
                ArrayList<String> command = new ArrayList<String>();
                while (tokenizer.hasMoreElements()) {
                    command.add((String)tokenizer.nextElement());
                }
                try {
                    int procCode;
                    Process process = new ProcessBuilder(command).redirectErrorStream(true).directory(compileDir).start();
                    BufferedReader procReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = procReader.readLine();
                    while (line != null) {
                        this.info(line, new Object[0]);
                        line = procReader.readLine();
                    }
                    try {
                        procCode = process.waitFor();
                    }
                    catch (InterruptedException e1) {
                        throw new EnunciateException("Unexpected inturruption of the C# compile process.");
                    }
                    if (procCode != 0) {
                        throw new EnunciateException("C# compile failed.");
                    }
                }
                catch (IOException e) {
                    throw new EnunciateException((Throwable)e);
                }
                FileArtifact assembly = new FileArtifact(this.getName(), "csharp.assembly", dll);
                assembly.setPublic(false);
                this.enunciate.addArtifact((Artifact)assembly);
                if (docXml.exists()) {
                    FileArtifact docs = new FileArtifact(this.getName(), "csharp.docs.xml", docXml);
                    docs.setPublic(false);
                    this.enunciate.addArtifact((Artifact)docs);
                }
            } else {
                this.info("Skipping C# compile because everything appears up-to-date.", new Object[0]);
            }
        } else {
            this.debug("Skipping C# compile because a compile executable was neither found nor provided.  The C# bundle will only include the sources.", new Object[0]);
        }
        return compileDir;
    }

    private void packageArtifacts(File srcDir, File compileDir) {
        File packageDir = this.getPackageDir();
        packageDir.mkdirs();
        if (!this.isUpToDateWithSources(packageDir)) {
            try {
                this.enunciate.copyDir(srcDir, compileDir, new File[0]);
                File bundle = new File(packageDir, this.getBundleFileName());
                boolean anyFiles = this.enunciate.zip(bundle, new File[]{compileDir});
                if (anyFiles) {
                    ClientLibraryArtifact artifactBundle = new ClientLibraryArtifact(this.getName(), "csharp.client.library", "C# Client Library");
                    artifactBundle.setPlatform(".NET 2.0");
                    StringBuilder builder = new StringBuilder("C# source code");
                    boolean docsExist = new File(compileDir, this.getDocXmlFileName()).exists();
                    boolean dllExists = new File(compileDir, this.getDLLFileName()).exists();
                    if (docsExist && dllExists) {
                        builder.append(", the assembly, and the XML docs");
                    } else if (dllExists) {
                        builder.append("and the assembly");
                    }
                    artifactBundle.setDescription((String)this.context.getProperty(LIRBARY_DESCRIPTION_PROPERTY));
                    FileArtifact binariesJar = new FileArtifact(this.getName(), "dotnet.client.bundle", bundle);
                    binariesJar.setArtifactType(ArtifactType.binaries);
                    binariesJar.setDescription(String.format("The %s for the C# client library.", builder.toString()));
                    binariesJar.setPublic(false);
                    artifactBundle.addArtifact(binariesJar);
                    this.enunciate.addArtifact((Artifact)artifactBundle);
                }
            }
            catch (IOException e) {
                throw new EnunciateException((Throwable)e);
            }
        }
    }

    protected File getSourceDir() {
        return new File(new File(this.enunciate.getBuildDir(), this.getName()), "src");
    }

    protected File getCompileDir() {
        return new File(new File(this.enunciate.getBuildDir(), this.getName()), "compile");
    }

    protected File getPackageDir() {
        return new File(new File(this.enunciate.getBuildDir(), this.getName()), "build");
    }

    protected String packageToNamespace(String pckg) {
        if (pckg == null) {
            return null;
        }
        StringBuilder ns = new StringBuilder();
        StringTokenizer toks = new StringTokenizer(pckg, ".");
        while (toks.hasMoreTokens()) {
            String tok = toks.nextToken();
            ns.append(Character.toString(tok.charAt(0)).toUpperCase());
            if (tok.length() > 1) {
                ns.append(tok.substring(1));
            }
            if (!toks.hasMoreTokens()) continue;
            ns.append('.');
        }
        return ns.toString();
    }

    protected String readLibraryDescription(Map<String, Object> model) {
        model.put("sample_service_method", this.findExampleWebMethod());
        model.put("sample_resource", this.findExampleResourceMethod());
        URL res = CSharpXMLClientModule.class.getResource("library_description.fmt");
        try {
            return this.processTemplate(res, model);
        }
        catch (TemplateException e) {
            throw new EnunciateException((Throwable)e);
        }
        catch (IOException e) {
            throw new EnunciateException((Throwable)e);
        }
    }

    public String processTemplate(URL templateURL, Object model) throws IOException, TemplateException {
        this.debug("Processing template %s.", new Object[]{templateURL});
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_22);
        configuration.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

            protected URL getURL(String name) {
                try {
                    return new URL(name);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        });
        configuration.setTemplateExceptionHandler(new TemplateExceptionHandler(){

            public void handleTemplateException(TemplateException templateException, Environment environment, Writer writer) throws TemplateException {
                throw templateException;
            }
        });
        configuration.setLocalizedLookup(false);
        configuration.setDefaultEncoding("UTF-8");
        configuration.setObjectWrapper((ObjectWrapper)new CSharpXMLClientObjectWrapper());
        Template template = configuration.getTemplate(templateURL.toString());
        StringWriter unhandledOutput = new StringWriter();
        template.process(model, (Writer)unhandledOutput);
        unhandledOutput.close();
        return unhandledOutput.toString();
    }

    public WebMethod findExampleWebMethod() {
        WebMethod example = null;
        for (EndpointInterface ei : this.jaxwsModule.getJaxwsContext().getEndpointInterfaces()) {
            for (WebMethod method : ei.getWebMethods()) {
                if (method.getAnnotation(DocumentationExample.class) != null && !((DocumentationExample)method.getAnnotation(DocumentationExample.class)).exclude()) {
                    return method;
                }
                if (method.getJavaDoc().get((Object)"documentationExample") != null) {
                    return method;
                }
                if (method.getWebResult() != null && method.getWebResult().getType() instanceof DeclaredType && (example == null || example.getWebResult() == null || !(example.getWebResult().getType() instanceof DeclaredType))) {
                    example = method;
                    continue;
                }
                example = example == null ? method : example;
            }
        }
        return example;
    }

    public Method findExampleResourceMethod() {
        Method example = null;
        List resourceGroups = this.jaxrsModule.getJaxrsContext().getResourceGroups((ApiRegistrationContext)new DefaultRegistrationContext());
        for (ResourceGroup resourceGroup : resourceGroups) {
            List resources = resourceGroup.getResources();
            for (Resource resource : resources) {
                for (Method method : resource.getMethods()) {
                    if (!this.hasXmlResponseEntity(method)) continue;
                    if (this.hasXmlRequestEntity(method)) {
                        return method;
                    }
                    example = example == null ? method : example;
                }
            }
        }
        return example;
    }

    private boolean hasXmlResponseEntity(Method method) {
        if (method.getResponseEntity() != null) {
            for (MediaTypeDescriptor mediaTypeDescriptor : method.getResponseEntity().getMediaTypes()) {
                if (!"XML".equals(mediaTypeDescriptor.getSyntax())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasXmlRequestEntity(Method method) {
        if (method.getRequestEntity() != null) {
            for (MediaTypeDescriptor mediaTypeDescriptor : method.getRequestEntity().getMediaTypes()) {
                if (!"XML".equals(mediaTypeDescriptor.getSyntax())) continue;
                return true;
            }
        }
        return false;
    }

    protected String getBundleFileName() {
        return this.config.getString("[@bundleFileName]", this.getSlug() + "-dotnet.zip");
    }

    protected String getDLLFileName() {
        return this.config.getString("[@DLLFileName]", this.getSlug() + ".dll");
    }

    protected String getDocXmlFileName() {
        return this.config.getString("[@docXmlFileName]", this.getSlug() + "-docs.xml");
    }

    protected String getSourceFileName() {
        return this.config.getString("[@sourceFileName]", this.getSlug() + ".cs");
    }

    protected URL getTemplateURL(String template) {
        return CSharpXMLClientModule.class.getResource(template);
    }

    public boolean isRequire() {
        return this.config.getBoolean("[@require]", false);
    }

    public String getSlug() {
        return this.config.getString("[@slug]", this.enunciate.getConfiguration().getSlug());
    }

    public String getCompileExecutable() {
        return this.config.getString("[@compileExecutable]", null);
    }

    public String getCompileCommand() {
        return this.config.getString("[@compileCommand]", "%s /target:library /out:%s /r:System.Web.Services /doc:%s %s");
    }

    public Map<String, String> getPackageToNamespaceConversions() {
        List conversionElements = this.config.configurationsAt("package-conversions.convert");
        HashMap<String, String> conversions = new HashMap<String, String>();
        for (HierarchicalConfiguration conversionElement : conversionElements) {
            conversions.put(conversionElement.getString("[@from]"), conversionElement.getString("[@to]"));
        }
        return conversions;
    }

    public boolean isDisableCompile() {
        return this.config.getBoolean("[@disableCompile]", true);
    }

    public boolean isSingleFilePerClass() {
        return this.config.getBoolean("[@singleFilePerClass]", false);
    }

    public Set<String> getFacetIncludes() {
        List includes = this.config.getList("facets.include[@name]");
        TreeSet<String> facetIncludes = new TreeSet<String>();
        for (Object include : includes) {
            facetIncludes.add(String.valueOf(include));
        }
        return facetIncludes;
    }

    public Set<String> getFacetExcludes() {
        List excludes = this.config.getList("facets.exclude[@name]");
        TreeSet<String> facetExcludes = new TreeSet<String>();
        for (Object exclude : excludes) {
            facetExcludes.add(String.valueOf(exclude));
        }
        return facetExcludes;
    }
}

