/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.csharp_client;

import com.webcohesion.enunciate.modules.jaxws.model.WebMethod;
import com.webcohesion.enunciate.modules.jaxws.model.WebResult;
import com.webcohesion.enunciate.util.freemarker.FreemarkerUtil;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import jakarta.jws.soap.SOAPBinding;
import java.util.List;
import javax.xml.namespace.QName;

public class ResponseDocumentQNameMethod
implements TemplateMethodModelEx {
    public Object exec(List list) throws TemplateModelException {
        WebResult wr;
        if (list.size() < 1) {
            throw new TemplateModelException("The responseDocumentQName method method must have a web method as a parameter.");
        }
        TemplateModel from = (TemplateModel)list.get(0);
        Object unwrapped = FreemarkerUtil.unwrap((TemplateModel)from);
        if (!(unwrapped instanceof WebMethod)) {
            throw new TemplateModelException("A web method must be provided.");
        }
        WebMethod webMethod = (WebMethod)unwrapped;
        if (webMethod.getSoapBindingStyle() != SOAPBinding.Style.DOCUMENT || webMethod.getSoapUse() != SOAPBinding.Use.LITERAL) {
            throw new TemplateModelException("No response document qname available for a " + String.valueOf(webMethod.getSoapBindingStyle()) + "/" + String.valueOf(webMethod.getSoapUse()) + " web method.");
        }
        if (webMethod.getResponseWrapper() != null) {
            return new QName(webMethod.getResponseWrapper().getElementNamespace(), webMethod.getResponseWrapper().getElementName());
        }
        if (webMethod.getSoapParameterStyle() == SOAPBinding.ParameterStyle.BARE && !(wr = webMethod.getWebResult()).isHeader()) {
            return new QName(wr.getTargetNamespace(), wr.getElementName());
        }
        return null;
    }
}

