/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import java.nio.ByteBuffer;

public class UnsignedNumberUtil {
    public static final short UNSIGNED_BYTE_MAX = 255;
    public static final long UNSIGNED_INT_MAX = 0xFFFFFFFFL;

    private UnsignedNumberUtil() {
    }

    public static int getUnsignedShort(ByteBuffer byteBuffer) {
        return byteBuffer.getShort() & 0xFFFF;
    }

    public static long getUnsignedInt(ByteBuffer byteBuffer) {
        return (long)byteBuffer.getInt() & 0xFFFFFFFFL;
    }

    public static byte[] toBytes(int ushortValue) {
        byte[] bytes = new byte[2];
        bytes[1] = (byte)(0xFF & ushortValue);
        bytes[0] = (byte)(0xFF & ushortValue >>> 8);
        return bytes;
    }

    public static byte[] toBytes(long uintValue) {
        byte[] bytes = new byte[4];
        bytes[3] = (byte)(0xFFL & uintValue);
        bytes[2] = (byte)(0xFFL & uintValue >>> 8);
        bytes[1] = (byte)(0xFFL & uintValue >>> 16);
        bytes[0] = (byte)(0xFFL & uintValue >>> 24);
        return bytes;
    }
}

