/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.SignatureUtil;
import com.webauthn4j.util.exception.UnexpectedCheckedException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CertificateUtil {
    private static CertificateFactory certificateFactory;

    private CertificateUtil() {
    }

    public static CertPathValidator createCertPathValidator() {
        try {
            return CertPathValidator.getInstance("PKIX");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnexpectedCheckedException(e);
        }
    }

    public static PKIXParameters createPKIXParameters(Set<TrustAnchor> trustAnchors) {
        AssertUtil.notEmpty(trustAnchors, "trustAnchors is required; it must not be empty");
        try {
            return new PKIXParameters(trustAnchors);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new UnexpectedCheckedException(e);
        }
    }

    public static KeyStore createKeyStore() {
        try {
            return KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (KeyStoreException e) {
            throw new UnexpectedCheckedException(e);
        }
    }

    public static Set<TrustAnchor> generateTrustAnchors(List<X509Certificate> certificates) {
        return certificates.stream().map(certificate -> new TrustAnchor((X509Certificate)certificate, null)).collect(Collectors.toSet());
    }

    public static CertPath generateCertPath(List<Certificate> certificates) {
        try {
            return certificateFactory.generateCertPath(certificates);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static X509Certificate generateX509Certificate(byte[] bytes) {
        return CertificateUtil.generateX509Certificate(new ByteArrayInputStream(bytes));
    }

    public static X509Certificate generateX509Certificate(InputStream inputStream) {
        try {
            return (X509Certificate)certificateFactory.generateCertificate(inputStream);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isSelfSigned(X509Certificate certificate) {
        Signature signature = SignatureUtil.createSignature(certificate.getSigAlgName());
        try {
            signature.initVerify(certificate.getPublicKey());
        }
        catch (InvalidKeyException e) {
            return false;
        }
        try {
            signature.update(certificate.getPublicKey().getEncoded());
            signature.verify(certificate.getSignature());
        }
        catch (SignatureException e) {
            return false;
        }
        return true;
    }

    static {
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new UnexpectedCheckedException(e);
        }
    }
}

