/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.exception.UnexpectedCheckedException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CertificateUtil {
    private static final CertificateFactory certificateFactory;

    private CertificateUtil() {
    }

    public static @NonNull CertPathValidator createCertPathValidator() {
        try {
            return CertPathValidator.getInstance("PKIX");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnexpectedCheckedException(e);
        }
    }

    public static @NonNull PKIXParameters createPKIXParameters(@NonNull Set<TrustAnchor> trustAnchors) {
        AssertUtil.notEmpty(trustAnchors, "trustAnchors is required; it must not be empty");
        try {
            return new PKIXParameters(trustAnchors);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new UnexpectedCheckedException(e);
        }
    }

    public static @NonNull KeyStore createKeyStore() {
        try {
            return KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (KeyStoreException e) {
            throw new UnexpectedCheckedException(e);
        }
    }

    public static <C extends X509Certificate> @NonNull Set<TrustAnchor> generateTrustAnchors(@NonNull List<C> certificates) {
        return certificates.stream().map(certificate -> new TrustAnchor((X509Certificate)certificate, null)).collect(Collectors.toSet());
    }

    public static <C extends Certificate> @NonNull CertPath generateCertPath(@NonNull List<C> certificates) {
        try {
            return certificateFactory.generateCertPath(certificates);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static @NonNull X509Certificate generateX509Certificate(@NonNull byte[] bytes) {
        return CertificateUtil.generateX509Certificate(new ByteArrayInputStream(bytes));
    }

    public static @NonNull X509Certificate generateX509Certificate(@NonNull InputStream inputStream) {
        try {
            return (X509Certificate)certificateFactory.generateCertificate(inputStream);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static {
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new UnexpectedCheckedException(e);
        }
    }
}

