/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import com.webauthn4j.util.AssertUtil;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SignatureUtil {
    private SignatureUtil() {
    }

    @Deprecated
    public static @NonNull Signature getRS256() {
        return SignatureUtil.createRS256();
    }

    @Deprecated
    public static @NonNull Signature getES256() {
        return SignatureUtil.createES256();
    }

    public static @NonNull Signature createRS256() {
        return SignatureUtil.createSignature("SHA256withRSA");
    }

    public static @NonNull Signature createES256() {
        return SignatureUtil.createSignature("SHA256withECDSA");
    }

    public static @NonNull Signature createSignature(@NonNull String algorithm) {
        AssertUtil.notNull(algorithm, "algorithm is required; it must not be null");
        try {
            return Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

